/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.shade.org.apache.commons.beanutils.converters;

import com.sforce.ws.shade.org.apache.commons.beanutils.ConversionException;
import com.sforce.ws.shade.org.apache.commons.beanutils.Converter;

public final class IntegerConverter
implements Converter {
    private Object defaultValue = null;
    private boolean useDefault = true;

    public IntegerConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public IntegerConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    public Object convert(Class type, Object value) {
        if (value == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (value instanceof Integer) {
            return value;
        }
        if (value instanceof Number) {
            return new Integer(((Number)value).intValue());
        }
        try {
            return new Integer(value.toString());
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(e);
        }
    }
}

