/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.shade.org.apache.commons.beanutils.converters;

import com.sforce.ws.shade.org.apache.commons.beanutils.ConversionException;
import com.sforce.ws.shade.org.apache.commons.beanutils.converters.AbstractArrayConverter;
import java.util.List;

public final class LongArrayConverter
extends AbstractArrayConverter {
    private static long[] model = new long[0];

    public LongArrayConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public LongArrayConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    public Object convert(Class type, Object value) {
        if (value == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (model.getClass() == value.getClass()) {
            return value;
        }
        if (AbstractArrayConverter.strings.getClass() == value.getClass()) {
            try {
                String[] values = (String[])value;
                long[] results = new long[values.length];
                int i = 0;
                while (i < values.length) {
                    results[i] = Long.parseLong(values[i]);
                    ++i;
                }
                return results;
            }
            catch (Exception e) {
                if (this.useDefault) {
                    return this.defaultValue;
                }
                throw new ConversionException(value.toString(), e);
            }
        }
        try {
            List list = this.parseElements(value.toString());
            long[] results = new long[list.size()];
            int i = 0;
            while (i < results.length) {
                results[i] = Long.parseLong((String)list.get(i));
                ++i;
            }
            return results;
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(value.toString(), e);
        }
    }
}

