/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.shade.org.codehaus.jackson.map.deser.std;

import com.sforce.ws.shade.org.codehaus.jackson.JsonParser;
import com.sforce.ws.shade.org.codehaus.jackson.JsonProcessingException;
import com.sforce.ws.shade.org.codehaus.jackson.JsonToken;
import com.sforce.ws.shade.org.codehaus.jackson.map.DeserializationContext;
import com.sforce.ws.shade.org.codehaus.jackson.map.deser.std.StdScalarDeserializer;
import com.sforce.ws.shade.org.codehaus.jackson.type.JavaType;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTypeDeserializer
extends StdScalarDeserializer<JavaType> {
    public JavaTypeDeserializer() {
        super(JavaType.class);
    }

    @Override
    public JavaType deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken curr = jp.getCurrentToken();
        if (curr == JsonToken.VALUE_STRING) {
            String str = jp.getText().trim();
            if (str.length() == 0) {
                return (JavaType)this.getEmptyValue();
            }
            return ctxt.getTypeFactory().constructFromCanonical(str);
        }
        if (curr == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return (JavaType)jp.getEmbeddedObject();
        }
        throw ctxt.mappingException(this._valueClass);
    }
}

