/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.wsdl;

import com.sforce.ws.ConnectionException;
import com.sforce.ws.wsdl.Definitions;
import com.sforce.ws.wsdl.Message;
import com.sforce.ws.wsdl.ParserUtil;
import com.sforce.ws.wsdl.WsdlNode;
import com.sforce.ws.wsdl.WsdlParseException;
import com.sforce.ws.wsdl.WsdlParser;
import java.util.HashMap;
import javax.xml.namespace.QName;

public class Operation
extends WsdlNode {
    private MessageRef input;
    private MessageRef output;
    private HashMap<String, MessageRef> faults = new HashMap();
    private Definitions definitions;
    private QName name;

    public Operation(Definitions definitions) {
        this.definitions = definitions;
    }

    public QName getName() {
        return this.name;
    }

    public Message getInput() throws ConnectionException {
        return this.input == null ? null : this.definitions.getMessage(this.input.getMessage());
    }

    public Message getOutput() throws ConnectionException {
        return this.output == null ? null : this.definitions.getMessage(this.output.getMessage());
    }

    void read(WsdlParser parser) throws WsdlParseException {
        this.name = new QName(this.definitions.getTargetNamespace(), parser.getAttributeValue(null, "name"));
        int eventType = parser.getEventType();
        while (true) {
            if (eventType == 2) {
                String n = parser.getName();
                String ns = parser.getNamespace();
                if (n != null && ns != null) {
                    this.parse(n, ns, parser);
                }
            } else if (eventType == 3) {
                String name = parser.getName();
                String namespace = parser.getNamespace();
                if ("operation".equals(name) && "http://schemas.xmlsoap.org/wsdl/".equals(namespace)) {
                    return;
                }
            }
            eventType = parser.next();
        }
    }

    private void parse(String name, String namespace, WsdlParser parser) throws WsdlParseException {
        if ("http://schemas.xmlsoap.org/wsdl/".equals(namespace)) {
            if ("input".equals(name)) {
                String m = parser.getAttributeValue(null, "message");
                if (m == null) {
                    throw new WsdlParseException("message cant be null for operation: " + name);
                }
                this.input = new MessageRef(ParserUtil.toQName(m, parser));
            } else if ("output".equals(name)) {
                String m = parser.getAttributeValue(null, "message");
                this.output = new MessageRef(ParserUtil.toQName(m, parser));
            } else if ("fault".equals(name)) {
                String m = parser.getAttributeValue(null, "message");
                MessageRef fault = new MessageRef(ParserUtil.toQName(m, parser));
                String fn = parser.getAttributeValue(null, "name");
                if (fn == null) {
                    throw new WsdlParseException("Found a fault without name");
                }
                this.faults.put(fn, fault);
            }
        }
    }

    static class MessageRef
    extends WsdlNode {
        private QName message;

        public MessageRef(QName message) {
            this.message = message;
        }

        public QName getMessage() {
            return this.message;
        }
    }
}

