/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.codegen;

import com.sforce.ws.tools.ToolsException;
import com.sforce.ws.util.Verbose;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

class Compiler {
    private Object main;
    private Method method;

    public Compiler() throws ToolsException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        try {
            this.findCompiler(loader);
        }
        catch (ClassNotFoundException e) {
            this.findCompilerInToolsJar(loader);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            this.throwToolsexception(e);
        }
    }

    private void findCompilerInToolsJar(ClassLoader loader) throws ToolsException {
        try {
            URLClassLoader tloader = new URLClassLoader(new URL[]{Compiler.toolsJar()}, loader);
            this.findCompiler(tloader);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            this.throwToolsexception(e);
        }
    }

    private void findCompiler(ClassLoader loader) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException {
        Class<?> c = loader.loadClass("com.sun.tools.javac.Main");
        Class<?> arg = new String[0].getClass();
        this.main = c.newInstance();
        this.method = c.getMethod("compile", arg);
    }

    private void throwToolsexception(Exception e) throws ToolsException {
        e.printStackTrace();
        throw new ToolsException("Unable to find compiler. Make sure that tools.jar is in your classpath: " + e);
    }

    public void compile(String[] files, File dir) throws ToolsException {
        String target = System.getProperty("compileTarget");
        if (target == null) {
            target = "1.6";
        }
        Verbose.log("Compiling to target " + target + "... ");
        String[] args = new String[]{"-g", "-d", dir.getAbsolutePath(), "-sourcepath", dir.getAbsolutePath(), "-target", target, "-source", target};
        String[] call = new String[args.length + files.length];
        System.arraycopy(args, 0, call, 0, args.length);
        System.arraycopy(files, 0, call, args.length, files.length);
        try {
            Integer result = (Integer)this.method.invoke(this.main, new Object[]{call});
            if (result != 0) {
                throw new ToolsException("Failed to compile");
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ToolsException("Failed to compile: " + e);
        }
        Verbose.log("Compiled " + files.length + " java files.");
    }

    private static URL toolsJar() throws MalformedURLException {
        String javaHome = System.getProperty("java.home");
        if (javaHome.endsWith("jre")) {
            javaHome = javaHome.substring(0, javaHome.length() - 3);
        }
        if (!javaHome.endsWith("/")) {
            javaHome = javaHome + "/";
        }
        String tj = javaHome + "lib/tools.jar";
        File tjf = new File(tj);
        return tjf.toURI().toURL();
    }
}

