/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.oauth;

import com.force.sdk.connector.ForceConnectorConfig;
import com.force.sdk.connector.ForceConnectorUtils;
import com.force.sdk.connector.ForceServiceConnector;
import com.force.sdk.oauth.ForceRolePrincipal;
import com.force.sdk.oauth.ForceUserPrincipal;
import com.force.sdk.oauth.connector.ForceOAuthConnectionInfo;
import com.force.sdk.oauth.connector.ForceOAuthConnector;
import com.force.sdk.oauth.context.ForceSecurityContextHolder;
import com.force.sdk.oauth.context.SecurityContext;
import com.force.sdk.oauth.context.SecurityContextService;
import com.force.sdk.oauth.context.SecurityContextServiceImpl;
import com.force.sdk.oauth.context.store.ForceEncryptionException;
import com.force.sdk.oauth.context.store.SecurityContextCookieStore;
import com.force.sdk.oauth.context.store.SecurityContextSessionStore;
import com.force.sdk.oauth.exception.ForceOAuthSessionExpirationException;
import com.force.sdk.oauth.userdata.CustomUserDataRetrievalService;
import com.force.sdk.oauth.userdata.CustomUserDataRetriever;
import com.force.sdk.oauth.userdata.UserDataRetrievalService;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.SessionRenewer;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthFilter
implements Filter,
SessionRenewer {
    static final String FILTER_ALREADY_VISITED = "__force_auth_filter_already_visited";
    static final String SECURITY_AUTH_SUBJECT = "javax.security.auth.subject";
    static final String SECURITY_CONFIG_NAME = "ForceLogin";
    static final String DEFAULT_USER_PROFILE = "myProfile";
    static final String CONTEXT_STORE_SESSION_VALUE = "session";
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthFilter.class);
    private ForceOAuthConnector oauthConnector;
    private SecurityContextService securityContextService = null;
    private boolean logoutFromDatabaseCom = true;
    private String logoutUrl = "";

    /*
     * Unable to fully structure code
     */
    public void init(FilterConfig config) throws ServletException {
        AuthFilter.LOGGER.info("Initializing AuthFilter...");
        securityContextServiceImpl = new SecurityContextServiceImpl();
        customDataRetrieverName = config.getInitParameter("customDataRetriever");
        storeUsername = true;
        if ("false".equals(config.getInitParameter("storeUsername"))) {
            storeUsername = false;
        }
        userDataRetrievalService = null;
        if (customDataRetrieverName != null) {
            try {
                customDataRetrievalClass = Class.forName(customDataRetrieverName);
                customDataRetrievalObject = customDataRetrievalClass.newInstance();
                if (!(customDataRetrievalObject instanceof CustomUserDataRetriever)) ** GOTO lbl23
                customDataRetriever = (CustomUserDataRetriever)customDataRetrievalObject;
                userDataRetrievalService = new CustomUserDataRetrievalService(customDataRetriever, storeUsername);
            }
            catch (ClassNotFoundException e) {
                throw new ServletException("Custom user data retriever class not found: " + customDataRetrieverName, (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new ServletException("Custom user data retriever class could not be instantiated: " + customDataRetrieverName, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ServletException("Custom user data retriever class could not be instantiated: " + customDataRetrieverName, (Throwable)e);
            }
        } else {
            userDataRetrievalService = new UserDataRetrievalService(storeUsername);
        }
lbl23:
        // 3 sources

        securityContextServiceImpl.setUserDataRetrievalService(userDataRetrievalService);
        this.oauthConnector = new ForceOAuthConnector(userDataRetrievalService);
        connInfo = null;
        if (config.getInitParameter("endpoint") != null) {
            connInfo = new ForceOAuthConnectionInfo();
            connInfo.setEndpoint(config.getInitParameter("endpoint"));
            connInfo.setOauthKey(config.getInitParameter("oauthKey"));
            connInfo.setOauthSecret(config.getInitParameter("oauthSecret"));
            this.oauthConnector.setConnectionInfo(connInfo);
        } else if (config.getInitParameter("url") != null) {
            connInfo = new ForceOAuthConnectionInfo();
            connectionUrl = config.getInitParameter("url");
            if (ForceConnectorUtils.isInjectable((String)connectionUrl) && ((connectionUrl = ForceConnectorUtils.extractValue((String)connectionUrl)) == null || connectionUrl.equals(""))) {
                throw new IllegalArgumentException("Unable to load ForceConnectorConfig from environment or system property " + config.getInitParameter("url"));
            }
            connInfo.setConnectionUrl(connectionUrl);
            this.oauthConnector.setConnectionInfo(connInfo);
        } else if (config.getInitParameter("connectionName") != null) {
            this.oauthConnector.setConnectionName(config.getInitParameter("connectionName"));
        } else {
            throw new IllegalArgumentException("Could not find any init state for AuthFilter. Please specify an endpoint, oauthKey and oauthSecret or a connection url or a connection name.");
        }
        cookiePath = config.getInitParameter("cookiePath");
        if ((cookiePath == null || cookiePath.isEmpty()) && (cookiePath = config.getServletContext().getContextPath()).isEmpty()) {
            cookiePath = "/";
        }
        AuthFilter.LOGGER.info("Using " + cookiePath + " as path for session cookies");
        securityContextServiceImpl.setCookiePath(cookiePath);
        if ("session".equals(config.getInitParameter("securityContextStorageMethod"))) {
            securityContextServiceImpl.setSecurityContextStorageService(new SecurityContextSessionStore());
        } else {
            cookieStore = new SecurityContextCookieStore();
            try {
                if (config.getInitParameter("secure-key-config-var") != null) {
                    AuthFilter.LOGGER.info("Setting encryption key based on config var: " + config.getInitParameter("secure-key-config-var"));
                    key = ForceConnectorUtils.extractValue((String)config.getInitParameter("secure-key-config-var"));
                    cookieStore.setKey(key);
                } else {
                    AuthFilter.LOGGER.info("Setting encryption key based on file: " + config.getInitParameter("secure-key-file"));
                    cookieStore.setKeyFileName(config.getInitParameter("secure-key-file"));
                }
            }
            catch (ForceEncryptionException e) {
                throw new ServletException((Throwable)e);
            }
            cookieStore.setCookiePath(cookiePath);
            securityContextServiceImpl.setSecurityContextStorageService(cookieStore);
        }
        this.securityContextService = securityContextServiceImpl;
        if ("false".equalsIgnoreCase(config.getInitParameter("logoutFromDatabaseDotCom"))) {
            this.logoutFromDatabaseCom = false;
        }
        this.logoutUrl = config.getInitParameter("logoutUrl");
        if (this.logoutUrl == null || "".equals(this.logoutUrl)) {
            this.logoutUrl = "/logout";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest sreq, ServletResponse sres, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)sreq;
        HttpServletResponse response = (HttpServletResponse)sres;
        if (request.getAttribute(FILTER_ALREADY_VISITED) != null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        SecurityContext sc = null;
        if (!"/_auth".equals(request.getServletPath())) {
            sc = this.securityContextService.getSecurityContextFromSession(request);
        }
        if (this.isLogoutUrl(request)) {
            if (sc != null) {
                this.logout((ServletRequest)request, (ServletResponse)response, sc, chain);
            } else {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            return;
        }
        if (sc == null) {
            this.doOAuthLogin(request, response);
            return;
        }
        this.securityContextService.setSecurityContextToSession(request, response, sc);
        ForceSecurityContextHolder.set(sc);
        ForceConnectorConfig cc = new ForceConnectorConfig();
        cc.setSessionId(sc.getSessionId());
        cc.setServiceEndpoint(sc.getEndPoint());
        cc.setSessionRenewer((SessionRenewer)this);
        try {
            ForceServiceConnector.setThreadLocalConnectorConfig((ForceConnectorConfig)cc);
            request.setAttribute(FILTER_ALREADY_VISITED, (Object)Boolean.TRUE);
            chain.doFilter((ServletRequest)new AuthenticatedRequestWrapper(request, sc), (ServletResponse)response);
        }
        catch (ForceOAuthSessionExpirationException e) {
            this.doOAuthLogin(request, response);
        }
        catch (SecurityException se) {
            response.sendError(403, request.getRequestURI());
        }
        finally {
            try {
                request.removeAttribute(FILTER_ALREADY_VISITED);
            }
            finally {
                ForceSecurityContextHolder.release();
                ForceServiceConnector.setThreadLocalConnectorConfig(null);
            }
        }
    }

    private void doOAuthLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if ("/_auth".equals(request.getServletPath())) {
            this.securityContextService.setSecurityContextToSession(request, response, this.oauthConnector.getAccessToken(this.oauthConnector.getAccessCode(request), this.oauthConnector.getRedirectUri(request)));
            response.sendRedirect(response.encodeRedirectURL(request.getParameter("state")));
        } else {
            response.sendRedirect(this.oauthConnector.getLoginRedirectUrl(request));
        }
    }

    public void destroy() {
    }

    public SecurityContextService getSecurityContextService() {
        return this.securityContextService;
    }

    public SessionRenewer.SessionRenewalHeader renewSession(ConnectorConfig config) throws ConnectionException {
        throw new ForceOAuthSessionExpirationException();
    }

    private void logout(ServletRequest request, ServletResponse response, SecurityContext sc, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        ForceConnectorConfig config = new ForceConnectorConfig();
        try {
            config.setServiceEndpoint(sc.getEndPoint());
            config.setSessionId(sc.getSessionId());
            config.setSessionRenewer((SessionRenewer)this);
            ForceServiceConnector connector = new ForceServiceConnector();
            connector.setConnectorConfig(config);
            connector.getConnection().logout();
        }
        catch (ConnectionException e) {
            LOGGER.warn("Error logging out through API: ", (Object)e.getMessage());
            LOGGER.debug("Error logging out through API: ", (Throwable)e);
        }
        ForceSecurityContextHolder.release();
        this.securityContextService.clearSecurityContext(req, res);
        if (this.logoutFromDatabaseCom) {
            String forceComLogoutUrl = this.getForceDotComLogoutUrl(req, sc, null);
            res.sendRedirect(res.encodeRedirectURL(forceComLogoutUrl));
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean isLogoutUrl(HttpServletRequest request) {
        return this.logoutUrl != null && !"".equals(this.logoutUrl) && this.logoutUrl.equals(request.getServletPath());
    }

    private String getForceDotComLogoutUrl(HttpServletRequest request, SecurityContext sc, String logoutTargetUrl) {
        return this.oauthConnector.getForceLogoutUrl(request, sc.getEndPoint(), logoutTargetUrl);
    }

    private static final class AuthenticatedRequestWrapper
    extends HttpServletRequestWrapper {
        private final ForceUserPrincipal userP;
        private final ForceRolePrincipal roleP;

        public AuthenticatedRequestWrapper(HttpServletRequest request, SecurityContext sc) {
            super(request);
            this.userP = new ForceUserPrincipal(sc.getUserName(), sc.getSessionId());
            this.roleP = new ForceRolePrincipal(sc.getRole());
        }

        public String getRemoteUser() {
            return this.userP != null ? this.userP.getName() : super.getRemoteUser();
        }

        public Principal getUserPrincipal() {
            return this.userP != null ? this.userP : super.getUserPrincipal();
        }

        public boolean isUserInRole(String role) {
            return this.roleP != null ? this.roleP.getName().endsWith(role) : super.isUserInRole(role);
        }
    }
}

