/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.oauth.connector;

import com.force.sdk.connector.ForceConnectionProperty;
import com.force.sdk.connector.ForceConnectorUtils;
import java.io.IOException;
import java.util.Map;

public class ForceOAuthConnectionInfo {
    private static final int MIN_CONN_URL_PROPS = 3;
    private String endpoint;
    private String oauthKey;
    private String oauthSecret;

    static ForceOAuthConnectionInfo loadFromName(String connectionName) throws IOException {
        Map propMap = ForceConnectorUtils.loadConnectorPropsFromName((String)connectionName);
        if (propMap == null) {
            return null;
        }
        ForceOAuthConnectionInfo connInfo = new ForceOAuthConnectionInfo();
        connInfo.setPropsFromMap(propMap, connectionName);
        return connInfo;
    }

    StringBuffer appendOauthKeyParam(StringBuffer url) {
        return url.append("&client_id=").append(this.getOauthKey());
    }

    StringBuffer appendOauthSecretParam(StringBuffer url) {
        return url.append("&client_secret=").append(this.getOauthSecret());
    }

    public void setConnectionUrl(String connectionUrl) {
        Map propMap = ForceConnectorUtils.loadConnectorPropsFromUrl((String)connectionUrl);
        if (propMap == null || propMap.size() < 3) {
            throw new IllegalArgumentException("The connection url (" + connectionUrl + ") must contain at least three parts. " + "It should be in the form " + "force://<endPoint>?oauth_key=<oauthKey>&oauth_secret=<oauthSecret>");
        }
        this.setPropsFromMap(propMap, connectionUrl);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getOauthKey() {
        return this.oauthKey;
    }

    public void setOauthKey(String oauthKey) {
        this.oauthKey = oauthKey;
    }

    public String getOauthSecret() {
        return this.oauthSecret;
    }

    public void setOauthSecret(String oauthSecret) {
        this.oauthSecret = oauthSecret;
    }

    private void setPropsFromMap(Map<ForceConnectionProperty, String> propMap, String propSource) {
        String errorMessage = "Could not load valid ForceOAuthConnectionInfo properties from " + propSource + ".";
        String endpointValue = propMap.get(ForceConnectionProperty.ENDPOINT);
        ForceConnectionProperty.ENDPOINT.validateValue(endpointValue, errorMessage);
        this.setEndpoint(endpointValue);
        String oauthKeyValue = propMap.get(ForceConnectionProperty.OAUTH_KEY);
        ForceConnectionProperty.OAUTH_KEY.validateValue(oauthKeyValue, errorMessage);
        this.setOauthKey(oauthKeyValue);
        String oauthSecretValue = propMap.get(ForceConnectionProperty.OAUTH_SECRET);
        ForceConnectionProperty.OAUTH_SECRET.validateValue(oauthSecretValue, errorMessage);
        this.setOauthSecret(oauthSecretValue);
    }

    public void validate() {
        ForceConnectionProperty.ENDPOINT.validateValue(this.getEndpoint());
        ForceConnectionProperty.OAUTH_KEY.validateValue(this.getOauthKey());
        ForceConnectionProperty.OAUTH_SECRET.validateValue(this.getOauthSecret());
    }
}

