/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.oauth.connector;

import com.force.sdk.connector.ForceConnector;
import com.force.sdk.connector.ForceConnectorUtils;
import com.force.sdk.oauth.connector.ForceOAuthConnectionInfo;
import com.force.sdk.oauth.connector.TokenRetrievalService;
import com.force.sdk.oauth.connector.TokenRetrievalServiceImpl;
import com.force.sdk.oauth.context.SecurityContext;
import com.force.sdk.oauth.userdata.UserDataRetrievalService;
import com.sforce.ws.ConnectionException;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ForceOAuthConnector
implements ForceConnector {
    public static final String REDIRECT_AUTH_URI = "/_auth";
    public static final String LOGIN_REDIRECT_URL_ATTRIBUTE = "__login_redirect_url_attrbute__";
    private static final String LOCAL_HOST_PORT = "https://localhost:8443";
    private static final String ACCESS_TOKEN_JSON_KEY = "access_token";
    private static final String REFRESH_TOKEN_JSON_KEY = "refresh_token";
    private static final String INSTANCE_URL_JSON_KEY = "instance_url";
    private OAuthVersion version = OAuthVersion.VERSION_2_0;
    private ForceOAuthConnectionInfo connInfo;
    private String connectionName;
    private ForceOAuthConnectionInfo externalConnInfo;
    private UserDataRetrievalService userDataRetrievalService;
    private TokenRetrievalService tokenRetrievalService;

    public ForceOAuthConnector() {
        this.userDataRetrievalService = new UserDataRetrievalService();
        this.tokenRetrievalService = new TokenRetrievalServiceImpl();
    }

    public ForceOAuthConnector(UserDataRetrievalService userDataRetrievalService) {
        this.userDataRetrievalService = userDataRetrievalService;
        this.tokenRetrievalService = new TokenRetrievalServiceImpl();
    }

    public SecurityContext getAccessToken(String accessCode, String redirectUri) throws IOException {
        StringBuffer urlParams = new StringBuffer("grant_type=authorization_code").append("&code=").append(accessCode).append("&redirect_uri=").append(URLEncoder.encode(redirectUri, "UTF-8"));
        this.getConnInfo().appendOauthKeyParam(urlParams);
        this.getConnInfo().appendOauthSecretParam(urlParams);
        return this.createTokenInternal(urlParams.toString(), null);
    }

    public SecurityContext refreshAccessToken(String refreshToken) throws IOException {
        StringBuffer urlParams = new StringBuffer("grant_type=refresh_token").append("&refresh_token=").append(refreshToken);
        this.getConnInfo().appendOauthKeyParam(urlParams);
        this.getConnInfo().appendOauthSecretParam(urlParams);
        return this.createTokenInternal(urlParams.toString(), refreshToken);
    }

    private SecurityContext createTokenInternal(String params, String refreshToken) throws IOException {
        String instanceUrl = null;
        String session = null;
        String refresh = refreshToken;
        try {
            String responsePayload = this.tokenRetrievalService.retrieveToken(this.getHostPort(this.connInfo.getEndpoint(), null), params, refreshToken, this.getConnInfo());
            JSONParser parser = new JSONParser();
            Map map = (Map)parser.parse(responsePayload);
            session = (String)map.get(ACCESS_TOKEN_JSON_KEY);
            if (session == null) {
                throw new IOException("Missing access token on response");
            }
            if (refresh == null && (refresh = (String)map.get(REFRESH_TOKEN_JSON_KEY)) == null) {
                throw new IOException("Missing refresh token on response");
            }
            instanceUrl = (String)map.get(INSTANCE_URL_JSON_KEY);
            if (instanceUrl == null) {
                throw new IOException("Missing instance url on response");
            }
            SecurityContext sc = this.userDataRetrievalService.retrieveUserData(session, ForceConnectorUtils.buildForceApiEndpoint((String)instanceUrl), refresh);
            return sc;
        }
        catch (ConnectionException ce) {
            throw new IOException("Unable to create token due to connection exception", ce);
        }
        catch (ParseException pe) {
            throw new IOException("Unable to create token due to parse exception", pe);
        }
    }

    public void close() {
        this.connInfo = null;
        this.connectionName = null;
        this.externalConnInfo = null;
    }

    public String getAccessCode(HttpServletRequest request) {
        return request.getParameter("code");
    }

    public String getForceLogoutUrl(HttpServletRequest request, String forceEndpoint, String localLogoutSuccessfulPath) {
        StringBuffer forceLogoutUrl = new StringBuffer(forceEndpoint.substring(0, forceEndpoint.indexOf(47, 9)) + "/secur/logout.jsp");
        if (localLogoutSuccessfulPath != null && localLogoutSuccessfulPath.length() > 0) {
            try {
                forceLogoutUrl.append("?retUrl=").append(this.getHostPort(request)).append(request.getContextPath()).append(URLEncoder.encode(localLogoutSuccessfulPath, "UTF-8"));
                this.getConnInfo().appendOauthKeyParam(forceLogoutUrl);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return forceLogoutUrl.toString();
    }

    public String getHostPort(HttpServletRequest request) {
        String host = request.getHeader("Host");
        if (host == null) {
            return LOCAL_HOST_PORT;
        }
        return this.getHostPort(host, request.getScheme());
    }

    public String getHostPort(String endpoint, String protocol) {
        String[] parsedEndpoint = endpoint.split("://", 2);
        String endpointWithoutProtocol = parsedEndpoint[parsedEndpoint.length - 1];
        if (protocol == null && parsedEndpoint.length == 2) {
            protocol = parsedEndpoint[0];
        }
        if (endpointWithoutProtocol.startsWith("localhost") || endpointWithoutProtocol.contains("internal")) {
            if (protocol != null) {
                return protocol + "://" + endpointWithoutProtocol;
            }
            return "http://" + endpointWithoutProtocol;
        }
        return "https://" + endpointWithoutProtocol;
    }

    public String getLoginRedirectUrl(HttpServletRequest request) throws IOException {
        StringBuffer state;
        String redirectAttribute = (String)request.getAttribute(LOGIN_REDIRECT_URL_ATTRIBUTE);
        if (redirectAttribute != null) {
            state = new StringBuffer(redirectAttribute);
        } else {
            state = new StringBuffer(this.getHostPort(request)).append(request.getContextPath()).append(request.getServletPath());
            if (request.getPathInfo() != null) {
                state.append(request.getPathInfo());
            }
            if (request.getQueryString() != null) {
                state.append("?" + request.getQueryString());
            }
        }
        StringBuffer loginRedirectUrl = new StringBuffer(this.getHostPort(this.getConnInfo().getEndpoint(), null)).append("/services/oauth2/authorize").append("?response_type=code").append("&redirect_uri=").append(URLEncoder.encode(this.getRedirectUri(request), "UTF-8")).append("&state=").append(URLEncoder.encode(state.toString(), "UTF-8"));
        this.getConnInfo().appendOauthKeyParam(loginRedirectUrl);
        return loginRedirectUrl.toString();
    }

    public String getRedirectUri(HttpServletRequest request) {
        return this.getHostPort(request) + request.getContextPath() + REDIRECT_AUTH_URI;
    }

    ForceOAuthConnectionInfo getConnInfo() throws IOException {
        if (this.connInfo == null) {
            if (this.externalConnInfo != null) {
                this.connInfo = this.externalConnInfo;
            } else if (this.connectionName != null) {
                this.connInfo = ForceOAuthConnectionInfo.loadFromName(this.connectionName);
            }
            if (this.connInfo == null) {
                StringBuffer errorMsg = new StringBuffer();
                errorMsg.append("No state was found to construct an oauth connection.").append(" Please provide an endpoint, key and secret or connection url.");
                if (this.connectionName != null) {
                    errorMsg.append(" Or create a classpath properties file, environment variable or java property for the name '").append(this.connectionName).append("'");
                }
                throw new IOException(errorMsg.toString());
            }
            this.connInfo.validate();
        }
        return this.connInfo;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionInfo(ForceOAuthConnectionInfo connectionInfo) {
        this.externalConnInfo = connectionInfo;
    }

    public void setOAuthVersion(String oauthVersion) {
        this.version = OAuthVersion.parse(oauthVersion);
    }

    public OAuthVersion getOAuthVersion() {
        return this.version;
    }

    public void setUserDataRetrievalService(UserDataRetrievalService userDataRetrievalService) {
        this.userDataRetrievalService = userDataRetrievalService;
    }

    public void setTokenRetrievalService(TokenRetrievalService tokenRetrievalService) {
        this.tokenRetrievalService = tokenRetrievalService;
    }

    public static enum OAuthVersion {
        VERSION_2_0;


        private static OAuthVersion parse(String version) {
            if ("2.0".equals(version)) {
                return VERSION_2_0;
            }
            throw new UnsupportedOperationException("Unsupported OAuth version: " + version);
        }
    }
}

