/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.oauth.context;

import com.force.sdk.oauth.context.SecurityContext;
import com.force.sdk.oauth.context.SecurityContextService;
import com.force.sdk.oauth.context.SecurityContextUtil;
import com.force.sdk.oauth.context.store.ContextStoreException;
import com.force.sdk.oauth.context.store.ForceEncryptionException;
import com.force.sdk.oauth.context.store.SecurityContextStorageService;
import com.force.sdk.oauth.userdata.UserDataRetrievalService;
import com.sforce.ws.ConnectionException;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityContextServiceImpl
implements SecurityContextService {
    private UserDataRetrievalService userDataRetrievalService = null;
    private SecurityContextStorageService securityContextStorageService = null;
    private String cookiePath = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityContextServiceImpl.class);

    public void setUserDataRetrievalService(UserDataRetrievalService userDataRetrievalService) {
        this.userDataRetrievalService = userDataRetrievalService;
    }

    public void setSecurityContextStorageService(SecurityContextStorageService securityContextStorageService) {
        this.securityContextStorageService = securityContextStorageService;
    }

    @Override
    public void setSecurityContextToSession(HttpServletRequest request, HttpServletResponse response, SecurityContext sc) {
        try {
            this.securityContextStorageService.storeSecurityContext(request, response, sc);
        }
        catch (ContextStoreException e) {
            LOGGER.error("Cannot store security information: ", (Throwable)e);
        }
        SecurityContextUtil.setCookieValues(sc, response, SecurityContextUtil.useSecureCookies(request), this.cookiePath);
    }

    @Override
    public SecurityContext getSecurityContextFromSession(HttpServletRequest request) {
        SecurityContext sc = null;
        try {
            sc = this.securityContextStorageService.retreiveSecurityContext(request);
        }
        catch (ContextStoreException e) {
            LOGGER.warn("Could not retrieve security information, refreshing. Set up an encryption key file to avoid this warning.");
            return null;
        }
        sc = this.verifyAndRefreshSecurityContext(sc, request);
        return sc;
    }

    @Override
    public SecurityContext verifyAndRefreshSecurityContext(SecurityContext sc, HttpServletRequest request) {
        String sessionId = null;
        String endpoint = null;
        Map<String, String> cookieValueMap = SecurityContextUtil.getCookieValues(request);
        sessionId = cookieValueMap.get("force_sid");
        endpoint = cookieValueMap.get("force_ep");
        if (!(sc == null || sessionId != null && sessionId.equals(sc.getSessionId()) && endpoint != null && endpoint.equals(sc.getEndPoint()))) {
            sc = null;
        }
        if (sessionId != null && endpoint != null && sc == null) {
            try {
                sc = this.userDataRetrievalService.retrieveUserData(sessionId, endpoint, null);
            }
            catch (ConnectionException e) {
                LOGGER.info("Force.com session is invalid. Refreshing... ");
                sc = null;
            }
        }
        return sc;
    }

    @Override
    public void clearSecurityContext(HttpServletRequest request, HttpServletResponse response) {
        this.securityContextStorageService.clearSecurityContext(request, response);
        SecurityContextUtil.clearCookieValues(response);
    }

    @Override
    public SecretKeySpec getSecretKey() throws ForceEncryptionException {
        return this.securityContextStorageService.getSecureKey();
    }

    public void setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
    }
}

