/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.oauth.context.store;

import com.force.sdk.oauth.context.store.ForceEncryptionException;
import com.force.sdk.oauth.context.store.SecurityContextCookieStore;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AESUtil {
    static final String ALGORITHM = "AES";
    static final String PRIVATE_KEY_PROPERTY = "private-key";
    static final String PRIVATE_KEY_PATH = "encryption.properties";
    private static final Logger LOGGER = LoggerFactory.getLogger(AESUtil.class);
    private static final int KEY_SIZE = 128;

    private AESUtil() {
    }

    public static byte[] encrypt(byte[] value, SecretKeySpec skeySpec) throws ForceEncryptionException {
        try {
            Cipher cipher = null;
            cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, skeySpec);
            byte[] encrypted = null;
            encrypted = cipher.doFinal(value);
            return encrypted;
        }
        catch (BadPaddingException e) {
            throw new ForceEncryptionException(e);
        }
        catch (InvalidKeyException e) {
            throw new ForceEncryptionException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ForceEncryptionException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new ForceEncryptionException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new ForceEncryptionException(e);
        }
    }

    public static byte[] decrypt(byte[] value, SecretKeySpec skeySpec) throws ForceEncryptionException {
        try {
            Cipher cipher = null;
            cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, skeySpec);
            byte[] original = null;
            original = cipher.doFinal(value);
            return original;
        }
        catch (BadPaddingException e) {
            throw new ForceEncryptionException(e);
        }
        catch (InvalidKeyException e) {
            throw new ForceEncryptionException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ForceEncryptionException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new ForceEncryptionException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new ForceEncryptionException(e);
        }
    }

    public static SecretKeySpec recreateSecretKeySpec(String key) throws ForceEncryptionException {
        SecretKeySpec secretKey = null;
        if (key != null && key.trim().length() > 0) {
            secretKey = new SecretKeySpec(SecurityContextCookieStore.b64decode(key.trim()), ALGORITHM);
        }
        if (secretKey == null) {
            secretKey = AESUtil.generateRandomKey();
        }
        return secretKey;
    }

    public static SecretKeySpec getSecretKey() throws ForceEncryptionException {
        return AESUtil.getSecretKey(PRIVATE_KEY_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecretKeySpec getSecretKey(String fileName) throws ForceEncryptionException {
        if (fileName == null || fileName.length() == 0) {
            fileName = PRIVATE_KEY_PATH;
        }
        InputStream is = AESUtil.class.getResourceAsStream("/" + fileName);
        String key = null;
        if (is == null) {
            LOGGER.warn("Could not open file at  path " + fileName + ". Generating private key... ");
        } else {
            Properties encryptionProps = new Properties();
            try {
                encryptionProps.load(is);
            }
            catch (IOException e) {
                LOGGER.warn("Could not open file at  path " + fileName + ". Generating private key... ");
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            key = encryptionProps.getProperty(PRIVATE_KEY_PROPERTY);
            if (key == null || key.trim().length() == 0) {
                LOGGER.warn("private-key property was null in file " + fileName + ". Generating private key... ");
            }
        }
        return AESUtil.getSecretKeySpec(key);
    }

    public static SecretKeySpec getSecretKeySpec(String key) throws ForceEncryptionException {
        SecretKeySpec secretKey = AESUtil.recreateSecretKeySpec(key);
        return secretKey;
    }

    public static SecretKeySpec generateRandomKey() throws ForceEncryptionException {
        KeyGenerator keyGen;
        try {
            keyGen = KeyGenerator.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ForceEncryptionException(e);
        }
        keyGen.init(128);
        return new SecretKeySpec(keyGen.generateKey().getEncoded(), ALGORITHM);
    }
}

