/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.oauth.context.store;

import com.force.sdk.oauth.context.SecurityContext;
import com.force.sdk.oauth.context.SecurityContextUtil;
import com.force.sdk.oauth.context.store.AESUtil;
import com.force.sdk.oauth.context.store.ContextStoreException;
import com.force.sdk.oauth.context.store.ForceEncryptionException;
import com.force.sdk.oauth.context.store.SecurityContextStorageService;
import com.sforce.ws.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SecurityContextCookieStore
implements SecurityContextStorageService {
    public static final String SECURITY_CONTEXT_COOKIE_NAME = "security_context";
    private SecretKeySpec skeySpec = null;
    private boolean encrypted = true;
    private String cookiePath = null;

    @Override
    public void storeSecurityContext(HttpServletRequest request, HttpServletResponse response, SecurityContext securityContext) throws ContextStoreException {
        try {
            Cookie contextCookie = null;
            securityContext.setRefreshToken(null);
            byte[] securityContextSer = this.serializeSecurityContext(securityContext, this.encrypted);
            contextCookie = new Cookie(SECURITY_CONTEXT_COOKIE_NAME, URLEncoder.encode(SecurityContextCookieStore.b64encode(securityContextSer), "UTF-8"));
            contextCookie.setSecure(SecurityContextUtil.useSecureCookies(request));
            contextCookie.setPath(this.cookiePath);
            response.addCookie(contextCookie);
        }
        catch (ForceEncryptionException e) {
            throw new ContextStoreException(e);
        }
        catch (IOException e) {
            throw new ContextStoreException(e);
        }
    }

    @Override
    public SecurityContext retreiveSecurityContext(HttpServletRequest request) throws ContextStoreException {
        try {
            Cookie[] cookies = request.getCookies();
            String value = null;
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!SECURITY_CONTEXT_COOKIE_NAME.equals(cookie.getName())) continue;
                    value = URLDecoder.decode(cookie.getValue(), "UTF-8");
                }
            }
            if (value != null) {
                return this.deserializeSecurityContext(SecurityContextCookieStore.b64decode(value), this.encrypted);
            }
        }
        catch (IOException e) {
            throw new ContextStoreException(e);
        }
        catch (ForceEncryptionException e) {
            throw new ContextStoreException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ContextStoreException(e);
        }
        return null;
    }

    private byte[] serializeSecurityContext(SecurityContext sc, boolean encrypt) throws ForceEncryptionException, IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(sc);
        out.close();
        byte[] securityContextSer = bos.toByteArray();
        if (encrypt) {
            securityContextSer = AESUtil.encrypt(securityContextSer, this.getSecureKey());
        }
        return securityContextSer;
    }

    private SecurityContext deserializeSecurityContext(byte[] securityContextSer, boolean isEncrypted) throws ForceEncryptionException, IOException, ClassNotFoundException {
        if (isEncrypted) {
            securityContextSer = AESUtil.decrypt(securityContextSer, this.getSecureKey());
        }
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(securityContextSer));
        return (SecurityContext)in.readObject();
    }

    @Override
    public SecretKeySpec getSecureKey() throws ForceEncryptionException {
        if (this.skeySpec == null) {
            this.skeySpec = AESUtil.getSecretKey();
        }
        return this.skeySpec;
    }

    public void setKeyFileName(String fileName) throws ForceEncryptionException {
        this.skeySpec = AESUtil.getSecretKey(fileName);
    }

    public void setKey(String key) throws ForceEncryptionException {
        this.skeySpec = AESUtil.getSecretKeySpec(key);
    }

    public static String b64encode(byte[] b) {
        return new String(Base64.encode((byte[])b));
    }

    public static byte[] b64decode(String s) {
        return Base64.decode((byte[])s.getBytes());
    }

    @Override
    public void clearSecurityContext(HttpServletRequest request, HttpServletResponse response) {
        Cookie clearCookie = new Cookie(SECURITY_CONTEXT_COOKIE_NAME, "");
        clearCookie.setMaxAge(0);
        response.addCookie(clearCookie);
    }

    @Override
    public boolean isContextStored(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        for (int i = 0; i < cookies.length; ++i) {
            if (!SECURITY_CONTEXT_COOKIE_NAME.equals(cookies[i].getName())) continue;
            return true;
        }
        return false;
    }

    public void setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
    }
}

