/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.oauth.context.store;

import com.force.sdk.oauth.context.SecurityContext;
import com.force.sdk.oauth.context.store.ContextStoreException;
import com.force.sdk.oauth.context.store.SecurityContextStorageService;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SecurityContextSessionStore
implements SecurityContextStorageService {
    public static final String SECURITY_CONTEXT_SESSION_KEY = "com.force.sdk.securitycontext";

    @Override
    public void storeSecurityContext(HttpServletRequest request, HttpServletResponse response, SecurityContext securityContext) throws ContextStoreException {
        HttpSession session = request.getSession();
        session.setAttribute(SECURITY_CONTEXT_SESSION_KEY, (Object)securityContext);
    }

    @Override
    public SecurityContext retreiveSecurityContext(HttpServletRequest request) throws ContextStoreException {
        HttpSession session = request.getSession();
        SecurityContext sc = (SecurityContext)session.getAttribute(SECURITY_CONTEXT_SESSION_KEY);
        return sc;
    }

    @Override
    public void clearSecurityContext(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    @Override
    public SecretKeySpec getSecureKey() {
        return null;
    }

    @Override
    public boolean isContextStored(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        return session != null && session.getAttribute(SECURITY_CONTEXT_SESSION_KEY) != null;
    }
}

