/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.autoconfigure;

import de.codecentric.boot.admin.server.config.AdminServerAutoConfiguration;
import de.codecentric.boot.admin.server.config.AdminServerProperties;
import de.codecentric.boot.admin.server.web.servlet.AdminControllerHandlerMapping;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.reactive.function.client.WebClientAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
@Import(value={WebClientAutoConfiguration.class, AdminServerAutoConfiguration.class})
public class AdminServerAutoConfigurationAdapter
implements BeanDefinitionRegistryPostProcessor {
    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        if (registry.containsBeanDefinition("adminHandlerMapping")) {
            registry.removeBeanDefinition("adminHandlerMapping");
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public static class ServletRestApiConfiguration {
        private final AdminServerProperties adminServerProperties;

        public ServletRestApiConfiguration(AdminServerProperties adminServerProperties) {
            this.adminServerProperties = adminServerProperties;
        }

        @Bean
        public RequestMappingHandlerMapping exposedAwareAdminHandlerMapping(ContentNegotiationManager contentNegotiationManager) {
            AdminControllerHandlerMapping mapping = new AdminControllerHandlerMapping(this.adminServerProperties.getContextPath());
            mapping.setOrder(-1);
            mapping.setDetectHandlerMethodsInAncestorContexts(true);
            mapping.setContentNegotiationManager(contentNegotiationManager);
            return mapping;
        }
    }
}

