/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.autoconfigure;

import com.foreach.across.config.AcrossContextConfigurer;
import com.foreach.across.core.AcrossContext;
import com.foreach.across.core.context.bootstrap.AcrossBootstrapConfigurer;
import com.foreach.across.core.context.bootstrap.ModuleBootstrapConfig;
import com.foreach.across.core.context.configurer.AnnotatedClassConfigurer;
import com.foreach.across.core.context.configurer.ApplicationContextConfigurer;
import com.foreach.across.core.context.configurer.ConfigurerScope;
import com.foreach.across.core.context.info.AcrossContextInfo;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.cloud.autoconfigure.ConfigurationPropertiesRebinderAutoConfiguration;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.context.properties.ConfigurationPropertiesRebinder;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

@Configuration
@ConditionalOnClass(value={RefreshAutoConfiguration.class, RefreshScope.class})
@Import(value={RefreshAutoConfiguration.class})
public class CloudRefreshAutoConfigurationAdapter
implements AcrossContextConfigurer,
ApplicationContextAware,
AcrossBootstrapConfigurer,
ApplicationListener<EnvironmentChangeEvent> {
    private static final Set<String> STANDARD_SOURCES = new HashSet<String>(Arrays.asList("systemProperties", "systemEnvironment", "jndiProperties", "servletConfigInitParams", "servletContextInitParams"));
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void configure(AcrossContext context) {
        context.addApplicationContextConfigurer((ApplicationContextConfigurer)new AnnotatedClassConfigurer(new Class[]{RefreshScopeConfiguration.class, ConfigurationPropertiesRebinderAutoConfiguration.class}), ConfigurerScope.CONTEXT_ONLY);
    }

    public void configureModule(ModuleBootstrapConfig moduleConfiguration) {
        moduleConfiguration.extendModule(true, false, new String[]{RefreshScopeConfiguration.class.getName(), ConfigurationPropertiesRebinderAutoConfiguration.class.getName()});
    }

    public void onApplicationEvent(EnvironmentChangeEvent event) {
        AcrossContextInfo contextInfo = (AcrossContextInfo)this.applicationContext.getBean(AcrossContextInfo.class);
        ConfigurableEnvironment changedEnvironment = (ConfigurableEnvironment)this.applicationContext.getEnvironment();
        ConfigurableEnvironment contextEnvironment = this.refresh(contextInfo.getApplicationContext(), changedEnvironment);
        contextInfo.getModules().forEach(module -> this.refresh(module.getApplicationContext(), contextEnvironment));
    }

    private ConfigurableEnvironment refresh(ApplicationContext applicationContext, ConfigurableEnvironment updatedEnvironment) {
        ConfigurableEnvironment target = (ConfigurableEnvironment)applicationContext.getEnvironment();
        this.mergeEnvironments(target, updatedEnvironment);
        ((RefreshScope)applicationContext.getBean(RefreshScope.class)).refreshAll();
        ((ConfigurationPropertiesRebinder)applicationContext.getBean(ConfigurationPropertiesRebinder.class)).rebind();
        return target;
    }

    private void mergeEnvironments(ConfigurableEnvironment targetEnvironment, ConfigurableEnvironment updatedEnvironment) {
        MutablePropertySources target = targetEnvironment.getPropertySources();
        String targetName = null;
        for (PropertySource source : updatedEnvironment.getPropertySources()) {
            String name = source.getName();
            if (target.contains(name)) {
                targetName = name;
            }
            if (STANDARD_SOURCES.contains(name)) continue;
            if (target.contains(name)) {
                target.replace(name, source);
                continue;
            }
            if (targetName != null) {
                target.addAfter(targetName, source);
                continue;
            }
            target.addFirst(source);
            targetName = name;
        }
    }

    @ConditionalOnMissingBean(value={RefreshScope.class}, search=SearchStrategy.CURRENT)
    protected static class RefreshScopeConfiguration
    implements BeanDefinitionRegistryPostProcessor {
        protected RefreshScopeConfiguration() {
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            if (!registry.containsBeanDefinition("refreshScope")) {
                registry.registerBeanDefinition("refreshScope", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(RefreshScope.class).setRole(2).getBeanDefinition());
            }
        }
    }
}

