/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.autoconfigure.hateoas;

import com.foreach.across.autoconfigure.support.AcrossContextResolvingBeanTargetSource;
import com.foreach.across.core.context.bootstrap.ModuleBootstrapConfig;
import com.foreach.across.core.context.info.AcrossModuleInfo;
import com.foreach.across.core.context.registry.AcrossContextBeanRegistry;
import com.foreach.across.core.events.AcrossModuleBootstrappedEvent;
import com.foreach.across.core.filters.BeanFilter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.hateoas.server.EntityLinks;
import org.springframework.hateoas.server.LinkRelationProvider;

@Configuration
class EntityLinksConfiguration {
    private final AcrossModuleInfo currentModule;

    @Bean
    @ConditionalOnMissingBean(value={LinkRelationProvider.class})
    @Primary
    public LinkRelationProvider internalRelProvider(AcrossContextBeanRegistry beanRegistry) {
        AcrossContextResolvingBeanTargetSource targetSource = new AcrossContextResolvingBeanTargetSource();
        targetSource.setBeanRegistry(beanRegistry);
        targetSource.setModuleName("AcrossContextPostProcessorModule");
        targetSource.setBeanType(LinkRelationProvider.class);
        return (LinkRelationProvider)ProxyFactory.getProxy(LinkRelationProvider.class, (TargetSource)targetSource);
    }

    @Bean
    @ConditionalOnMissingBean(value={EntityLinks.class})
    @Primary
    public EntityLinks internalEntityLinks(AcrossContextBeanRegistry beanRegistry) {
        AcrossContextResolvingBeanTargetSource targetSource = new AcrossContextResolvingBeanTargetSource();
        targetSource.setBeanRegistry(beanRegistry);
        targetSource.setModuleName("AcrossContextPostProcessorModule");
        targetSource.setBeanType(EntityLinks.class);
        return (EntityLinks)ProxyFactory.getProxy(EntityLinks.class, (TargetSource)targetSource);
    }

    @EventListener
    @Order
    public void suppressInternalBeans(AcrossModuleBootstrappedEvent moduleBootstrappedEvent) {
        if (StringUtils.equals((CharSequence)this.currentModule.getName(), (CharSequence)moduleBootstrappedEvent.getModule().getName())) {
            ModuleBootstrapConfig bootstrapConfiguration = moduleBootstrappedEvent.getModule().getBootstrapConfiguration();
            bootstrapConfiguration.setExposeFilter(this.hateaosInfrastructureBeans(bootstrapConfiguration.getExposeFilter()));
        }
    }

    private BeanFilter hateaosInfrastructureBeans(BeanFilter originalExposeFilter) {
        return (beanFactory, beanName, bean, definition) -> {
            if (StringUtils.equals((CharSequence)"internalRelProvider", (CharSequence)beanName) || StringUtils.equals((CharSequence)"internalEntityLinks", (CharSequence)beanName)) {
                return false;
            }
            return originalExposeFilter.apply(beanFactory, beanName, bean, definition);
        };
    }

    public EntityLinksConfiguration(AcrossModuleInfo currentModule) {
        this.currentModule = currentModule;
    }
}

