/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate;

import com.foreach.across.core.AcrossModule;
import com.foreach.across.modules.hibernate.AcrossHibernateModuleSettings;
import com.foreach.across.modules.hibernate.provider.HibernatePackageProvider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractHibernatePackageModule
extends AcrossModule {
    private DataSource dataSource;
    private String dataSourceName = "acrossDataSource";
    private boolean scanForHibernatePackages = true;
    private Set<HibernatePackageProvider> hibernatePackageProviders = new HashSet<HibernatePackageProvider>();
    private String propertiesPrefix;

    public String getPropertiesPrefix() {
        return this.propertiesPrefix != null ? this.propertiesPrefix : StringUtils.uncapitalize((String)this.getName());
    }

    protected final void setPropertiesPrefix(String propertiesPrefix) {
        String previousPrefix = this.getPropertiesPrefix();
        this.propertiesPrefix = propertiesPrefix;
        HashSet propertiesToReplace = new HashSet();
        Properties properties = this.getProperties();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (key instanceof String && ((String)key).startsWith(previousPrefix + ".")) {
                propertiesToReplace.add((String)key);
            }
        }));
        propertiesToReplace.forEach(propertyName -> {
            String newPropertyName = StringUtils.replaceOnce((String)propertyName, (String)(previousPrefix + "."), (String)(propertiesPrefix + "."));
            properties.put(newPropertyName, properties.remove(propertyName));
        });
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Set<HibernatePackageProvider> getHibernatePackageProviders() {
        return this.hibernatePackageProviders;
    }

    public void setHibernatePackageProviders(Set<HibernatePackageProvider> hibernatePackageProviders) {
        this.hibernatePackageProviders = hibernatePackageProviders;
    }

    public void addHibernatePackageProvider(HibernatePackageProvider ... hibernatePackageProvider) {
        this.hibernatePackageProviders.addAll(Arrays.asList(hibernatePackageProvider));
    }

    public boolean isScanForHibernatePackages() {
        return this.scanForHibernatePackages;
    }

    public void setScanForHibernatePackages(boolean scanForHibernatePackages) {
        this.scanForHibernatePackages = scanForHibernatePackages;
    }

    public AcrossHibernateModuleSettings createSettings() {
        return new AcrossHibernateModuleSettings();
    }

    public Map<String, String> getHibernateProperties() {
        HashMap props = (HashMap)this.getProperties().get(this.getPropertiesPrefix() + ".hibernateProperties");
        if (props == null) {
            props = new HashMap();
            this.setProperty(this.getPropertiesPrefix() + ".hibernateProperties", props);
        }
        return props;
    }

    public void setHibernateProperties(Map<String, String> hibernateProperties) {
        Map<String, String> current = this.getHibernateProperties();
        current.clear();
        current.putAll(hibernateProperties);
    }

    public void setHibernateProperty(String name, String value) {
        this.getHibernateProperties().put(name, value);
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }
}

