/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate;

import com.foreach.across.modules.hibernate.config.PersistenceContextInView;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateSettings;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.autoconfigure.transaction.TransactionProperties;

public class AcrossHibernateModuleSettings
extends JpaProperties {
    public static final String HIBERNATE_PROPERTIES = "across-hibernate.hibernate-properties";
    public static final String PERSISTENCE_CONTEXT_VIEW_HANDLER = "across-hibernate.persistence-context-in-view.handler";
    public static final String PERSISTENCE_CONTEXT_VIEW_HANDLER_ORDER = "across-hibernate.persistence-context-in-view.order";
    public static final String CREATE_UNITOFWORK_FACTORY = "across-hibernate.create-unit-of-work-factory";
    public static final String REGISTER_REPOSITORY_INTERCEPTOR = "across-hibernate.register-repository-interceptor";
    public static final String ADVANCED_DTO_CONVERSION = "across-hibernate.advanced-dto-conversion";
    private TransactionProperties transactionProperties = new TransactionProperties();
    private HibernateProperties hibernate = new HibernateProperties();
    private ApplicationModule applicationModule = new ApplicationModule();
    private PersistenceContextInViewProperties persistenceContextInView = new PersistenceContextInViewProperties();
    private String dataSource;
    private Map<String, String> hibernateProperties = new HashMap<String, String>();
    private boolean createUnitOfWorkFactory = false;
    private boolean registerRepositoryInterceptor = false;
    private boolean advancedDtoConversion = false;

    public AcrossHibernateModuleSettings() {
        this.setOpenInView(true);
    }

    public boolean isOpenInView() {
        return Boolean.TRUE.equals(this.getOpenInView());
    }

    public Map<String, Object> getHibernateProperties(HibernateSettings hibernateSettings) {
        Map hibernateProperties = this.getHibernate().determineHibernateProperties(this.getProperties(), hibernateSettings);
        hibernateProperties.putAll(this.getHibernateProperties());
        return hibernateProperties;
    }

    public TransactionProperties getTransactionProperties() {
        return this.transactionProperties;
    }

    public HibernateProperties getHibernate() {
        return this.hibernate;
    }

    public ApplicationModule getApplicationModule() {
        return this.applicationModule;
    }

    public PersistenceContextInViewProperties getPersistenceContextInView() {
        return this.persistenceContextInView;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    @Deprecated
    public Map<String, String> getHibernateProperties() {
        return this.hibernateProperties;
    }

    public boolean isCreateUnitOfWorkFactory() {
        return this.createUnitOfWorkFactory;
    }

    public boolean isRegisterRepositoryInterceptor() {
        return this.registerRepositoryInterceptor;
    }

    public boolean isAdvancedDtoConversion() {
        return this.advancedDtoConversion;
    }

    public void setTransactionProperties(TransactionProperties transactionProperties) {
        this.transactionProperties = transactionProperties;
    }

    public void setHibernate(HibernateProperties hibernate) {
        this.hibernate = hibernate;
    }

    public void setApplicationModule(ApplicationModule applicationModule) {
        this.applicationModule = applicationModule;
    }

    public void setPersistenceContextInView(PersistenceContextInViewProperties persistenceContextInView) {
        this.persistenceContextInView = persistenceContextInView;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    @Deprecated
    public void setHibernateProperties(Map<String, String> hibernateProperties) {
        this.hibernateProperties = hibernateProperties;
    }

    public void setCreateUnitOfWorkFactory(boolean createUnitOfWorkFactory) {
        this.createUnitOfWorkFactory = createUnitOfWorkFactory;
    }

    public void setRegisterRepositoryInterceptor(boolean registerRepositoryInterceptor) {
        this.registerRepositoryInterceptor = registerRepositoryInterceptor;
    }

    public void setAdvancedDtoConversion(boolean advancedDtoConversion) {
        this.advancedDtoConversion = advancedDtoConversion;
    }

    public String toString() {
        return "AcrossHibernateModuleSettings(transactionProperties=" + this.getTransactionProperties() + ", hibernate=" + this.getHibernate() + ", applicationModule=" + this.getApplicationModule() + ", persistenceContextInView=" + this.getPersistenceContextInView() + ", dataSource=" + this.getDataSource() + ", hibernateProperties=" + this.getHibernateProperties() + ", createUnitOfWorkFactory=" + this.isCreateUnitOfWorkFactory() + ", registerRepositoryInterceptor=" + this.isRegisterRepositoryInterceptor() + ", advancedDtoConversion=" + this.isAdvancedDtoConversion() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AcrossHibernateModuleSettings)) {
            return false;
        }
        AcrossHibernateModuleSettings other = (AcrossHibernateModuleSettings)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isCreateUnitOfWorkFactory() != other.isCreateUnitOfWorkFactory()) {
            return false;
        }
        if (this.isRegisterRepositoryInterceptor() != other.isRegisterRepositoryInterceptor()) {
            return false;
        }
        if (this.isAdvancedDtoConversion() != other.isAdvancedDtoConversion()) {
            return false;
        }
        TransactionProperties this$transactionProperties = this.getTransactionProperties();
        TransactionProperties other$transactionProperties = other.getTransactionProperties();
        if (this$transactionProperties == null ? other$transactionProperties != null : !this$transactionProperties.equals(other$transactionProperties)) {
            return false;
        }
        HibernateProperties this$hibernate = this.getHibernate();
        HibernateProperties other$hibernate = other.getHibernate();
        if (this$hibernate == null ? other$hibernate != null : !this$hibernate.equals(other$hibernate)) {
            return false;
        }
        ApplicationModule this$applicationModule = this.getApplicationModule();
        ApplicationModule other$applicationModule = other.getApplicationModule();
        if (this$applicationModule == null ? other$applicationModule != null : !((Object)this$applicationModule).equals(other$applicationModule)) {
            return false;
        }
        PersistenceContextInViewProperties this$persistenceContextInView = this.getPersistenceContextInView();
        PersistenceContextInViewProperties other$persistenceContextInView = other.getPersistenceContextInView();
        if (this$persistenceContextInView == null ? other$persistenceContextInView != null : !((Object)this$persistenceContextInView).equals(other$persistenceContextInView)) {
            return false;
        }
        String this$dataSource = this.getDataSource();
        String other$dataSource = other.getDataSource();
        if (this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource)) {
            return false;
        }
        Map<String, String> this$hibernateProperties = this.getHibernateProperties();
        Map<String, String> other$hibernateProperties = other.getHibernateProperties();
        return !(this$hibernateProperties == null ? other$hibernateProperties != null : !((Object)this$hibernateProperties).equals(other$hibernateProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AcrossHibernateModuleSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isCreateUnitOfWorkFactory() ? 79 : 97);
        result = result * 59 + (this.isRegisterRepositoryInterceptor() ? 79 : 97);
        result = result * 59 + (this.isAdvancedDtoConversion() ? 79 : 97);
        TransactionProperties $transactionProperties = this.getTransactionProperties();
        result = result * 59 + ($transactionProperties == null ? 43 : $transactionProperties.hashCode());
        HibernateProperties $hibernate = this.getHibernate();
        result = result * 59 + ($hibernate == null ? 43 : $hibernate.hashCode());
        ApplicationModule $applicationModule = this.getApplicationModule();
        result = result * 59 + ($applicationModule == null ? 43 : ((Object)$applicationModule).hashCode());
        PersistenceContextInViewProperties $persistenceContextInView = this.getPersistenceContextInView();
        result = result * 59 + ($persistenceContextInView == null ? 43 : ((Object)$persistenceContextInView).hashCode());
        String $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        Map<String, String> $hibernateProperties = this.getHibernateProperties();
        result = result * 59 + ($hibernateProperties == null ? 43 : ((Object)$hibernateProperties).hashCode());
        return result;
    }

    public static class PersistenceContextInViewProperties {
        private PersistenceContextInView handler = PersistenceContextInView.FILTER;
        private int order = -2147483647;

        public PersistenceContextInView getHandler() {
            return this.handler;
        }

        public int getOrder() {
            return this.order;
        }

        public void setHandler(PersistenceContextInView handler) {
            this.handler = handler;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PersistenceContextInViewProperties)) {
                return false;
            }
            PersistenceContextInViewProperties other = (PersistenceContextInViewProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getOrder() != other.getOrder()) {
                return false;
            }
            PersistenceContextInView this$handler = this.getHandler();
            PersistenceContextInView other$handler = other.getHandler();
            return !(this$handler == null ? other$handler != null : !((Object)((Object)this$handler)).equals((Object)other$handler));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PersistenceContextInViewProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getOrder();
            PersistenceContextInView $handler = this.getHandler();
            result = result * 59 + ($handler == null ? 43 : ((Object)((Object)$handler)).hashCode());
            return result;
        }

        public String toString() {
            return "AcrossHibernateModuleSettings.PersistenceContextInViewProperties(handler=" + (Object)((Object)this.getHandler()) + ", order=" + this.getOrder() + ")";
        }
    }

    public static class ApplicationModule {
        private boolean entityScan = false;
        private boolean repositoryScan = false;

        public boolean isEntityScan() {
            return this.entityScan;
        }

        public boolean isRepositoryScan() {
            return this.repositoryScan;
        }

        public void setEntityScan(boolean entityScan) {
            this.entityScan = entityScan;
        }

        public void setRepositoryScan(boolean repositoryScan) {
            this.repositoryScan = repositoryScan;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApplicationModule)) {
                return false;
            }
            ApplicationModule other = (ApplicationModule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEntityScan() != other.isEntityScan()) {
                return false;
            }
            return this.isRepositoryScan() == other.isRepositoryScan();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ApplicationModule;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEntityScan() ? 79 : 97);
            result = result * 59 + (this.isRepositoryScan() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "AcrossHibernateModuleSettings.ApplicationModule(entityScan=" + this.isEntityScan() + ", repositoryScan=" + this.isRepositoryScan() + ")";
        }
    }
}

