/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.aop;

import com.foreach.across.modules.hibernate.aop.BasicRepositoryPointcut;
import com.foreach.across.modules.hibernate.aop.EntityInterceptor;
import java.util.ArrayList;
import java.util.Collection;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hibernate.Hibernate;
import org.springframework.util.ClassUtils;

public class BasicRepositoryInterceptor
implements MethodInterceptor {
    static final String CREATE = "create";
    static final String UPDATE = "update";
    static final String DELETE = "delete";
    private final Collection<EntityInterceptor> interceptors;

    public BasicRepositoryInterceptor(Collection<EntityInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (BasicRepositoryPointcut.isEntityMethod(invocation.getMethod())) {
            Object entityObject = invocation.getArguments()[0];
            String methodName = invocation.getMethod().getName();
            Collection<EntityInterceptor> interceptors = this.findInterceptorsToApply(entityObject, this.interceptors);
            this.callBefore(interceptors, methodName, entityObject);
            Object returnValue = invocation.proceed();
            this.callAfter(interceptors, methodName, entityObject);
            return returnValue;
        }
        return invocation.proceed();
    }

    private Collection<EntityInterceptor> findInterceptorsToApply(Object entity, Collection<EntityInterceptor> interceptors) {
        Class entityClass = ClassUtils.getUserClass((Class)Hibernate.getClass((Object)entity));
        ArrayList<EntityInterceptor> matchingInterceptors = new ArrayList<EntityInterceptor>();
        for (EntityInterceptor candidate : interceptors) {
            if (!candidate.handles(entityClass)) continue;
            matchingInterceptors.add(candidate);
        }
        return matchingInterceptors;
    }

    private void callBefore(Collection<EntityInterceptor> interceptors, String methodName, Object entity) {
        for (EntityInterceptor interceptor : interceptors) {
            switch (methodName) {
                case "create": {
                    interceptor.beforeCreate(entity);
                    break;
                }
                case "update": {
                    interceptor.beforeUpdate(entity);
                    break;
                }
                case "delete": {
                    interceptor.beforeDelete(entity);
                }
            }
        }
    }

    private void callAfter(Collection<EntityInterceptor> interceptors, String methodName, Object entity) {
        for (EntityInterceptor interceptor : interceptors) {
            switch (methodName) {
                case "create": {
                    interceptor.afterCreate(entity);
                    break;
                }
                case "update": {
                    interceptor.afterUpdate(entity);
                    break;
                }
                case "delete": {
                    interceptor.afterDelete(entity);
                }
            }
        }
    }
}

