/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.aop;

import com.foreach.across.modules.hibernate.repositories.BasicRepository;
import java.lang.reflect.Method;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.util.ClassUtils;

public class BasicRepositoryPointcut
extends StaticMethodMatcherPointcut {
    private static final ClassFilter CLASS_FILTER = clazz -> BasicRepository.class.isAssignableFrom(ClassUtils.getUserClass((Class)clazz));

    public ClassFilter getClassFilter() {
        return CLASS_FILTER;
    }

    public boolean matches(Method method, Class<?> targetClass) {
        return BasicRepositoryPointcut.isEntityMethod(method);
    }

    static boolean isEntityMethod(Method method) {
        switch (method.getName()) {
            case "create": 
            case "update": 
            case "delete": {
                break;
            }
            default: {
                return false;
            }
        }
        return method.getParameterTypes().length == 1;
    }
}

