/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.business;

import com.foreach.across.modules.hibernate.business.EntityWithDto;
import com.foreach.across.modules.hibernate.business.IdBasedEntity;
import com.foreach.across.modules.hibernate.util.DtoUtils;
import java.util.Objects;
import javax.persistence.Transient;
import org.springframework.data.domain.Persistable;

public abstract class SettableIdBasedEntity<T extends Persistable<Long>>
implements IdBasedEntity,
Persistable<Long>,
EntityWithDto<T> {
    @Transient
    private Long newEntityId;

    public abstract void setId(Long var1);

    public final boolean isNew() {
        return this.getId() == null || (Long)this.getId() == 0L;
    }

    public void setNewEntityId(Long newEntityId) {
        if (newEntityId != null) {
            this.setId(null);
            this.newEntityId = newEntityId;
        }
    }

    public Long getNewEntityId() {
        return this.getId() == null ? this.newEntityId : null;
    }

    @Override
    public T toDto() {
        return (T)DtoUtils.createDto(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().isAssignableFrom(o.getClass())) {
            return false;
        }
        SettableIdBasedEntity that = (SettableIdBasedEntity)o;
        if (this.isNew()) {
            return this == that;
        }
        return Objects.equals(this.getId(), that.getId());
    }

    public int hashCode() {
        return this.isNew() ? super.hashCode() : Objects.hash(this.getId());
    }
}

