/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.config;

import com.foreach.across.core.annotations.Exposed;
import com.foreach.across.core.annotations.Module;
import com.foreach.across.core.events.AcrossModuleBeforeBootstrapEvent;
import com.foreach.across.modules.hibernate.AcrossHibernateModule;
import com.foreach.across.modules.hibernate.AcrossHibernateModuleSettings;
import com.foreach.across.modules.hibernate.config.HibernatePackageBuilder;
import com.foreach.across.modules.hibernate.config.ModuleSettingsRegistrar;
import com.foreach.across.modules.hibernate.modules.config.EnableTransactionManagementConfiguration;
import com.foreach.across.modules.hibernate.modules.config.ModuleBasicRepositoryInterceptorConfiguration;
import com.foreach.across.modules.hibernate.provider.HibernatePackage;
import com.foreach.across.modules.hibernate.services.HibernateSessionHolder;
import com.foreach.across.modules.hibernate.services.HibernateSessionHolderImpl;
import com.foreach.across.modules.hibernate.strategy.TableAliasNamingStrategy;
import com.foreach.across.modules.hibernate.unitofwork.UnitOfWorkFactory;
import com.foreach.across.modules.hibernate.unitofwork.UnitOfWorkFactoryImpl;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.SessionFactory;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.dao.PersistenceExceptionTranslationAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateSettings;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.event.EventListener;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;

@Configuration
@Import(value={ModuleSettingsRegistrar.class, HibernatePackageBuilder.class, PersistenceExceptionTranslationAutoConfiguration.class})
public class HibernateConfiguration {
    public static final String TRANSACTION_MANAGER = "transactionManager";
    public static final String SESSION_HOLDER = "hibernateSessionHolder";
    private static final Logger LOG = LoggerFactory.getLogger(HibernateConfiguration.class);
    private final AcrossHibernateModule module;
    private final AcrossHibernateModuleSettings settings;
    private final ListableBeanFactory beanFactory;

    @Autowired
    public HibernateConfiguration(@Module(value="across.currentModule") AcrossHibernateModule module, @Module(value="across.currentModule") AcrossHibernateModuleSettings settings, ListableBeanFactory beanFactory) {
        this.module = module;
        this.settings = settings;
        this.beanFactory = beanFactory;
    }

    @Bean
    @Exposed
    public LocalSessionFactoryBean sessionFactory(HibernatePackage hibernatePackage) {
        LocalSessionFactoryBean sessionFactory = new LocalSessionFactoryBean();
        DataSource dataSource = this.retrieveDataSource();
        sessionFactory.setDataSource(dataSource);
        sessionFactory.setPackagesToScan(hibernatePackage.getPackagesToScan());
        sessionFactory.setMappingResources(hibernatePackage.getMappingResources());
        Map<String, String> tableAliases = hibernatePackage.getTableAliases();
        if (!tableAliases.isEmpty()) {
            sessionFactory.setPhysicalNamingStrategy((PhysicalNamingStrategy)new TableAliasNamingStrategy(tableAliases));
        }
        Properties propertiesToSet = new Properties();
        propertiesToSet.putAll(this.settings.getHibernateProperties(new HibernateSettings()));
        sessionFactory.setHibernateProperties(propertiesToSet);
        return sessionFactory;
    }

    private DataSource retrieveDataSource() {
        DataSource moduleDataSource = this.module.getDataSource();
        if (moduleDataSource != null) {
            LOG.info("Using datasource attached directly to module {} for the SessionFactory", (Object)this.module.getName());
            return moduleDataSource;
        }
        if (!StringUtils.isEmpty((CharSequence)this.settings.getDataSource())) {
            LOG.info("Resolving datasource bean {} for the SessionFactory", (Object)this.settings.getDataSource());
            return (DataSource)this.beanFactory.getBean(this.settings.getDataSource(), DataSource.class);
        }
        if (BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, DataSource.class).size() == 1) {
            LOG.info("Using the single datasource bean for the SessionFactory");
            return (DataSource)this.beanFactory.getBean(DataSource.class);
        }
        throw new IllegalStateException("Was unable to resolve the correct datasource bean to use, bean name: " + this.settings.getDataSource());
    }

    @Bean(name={"hibernateSessionHolder"})
    @Exposed
    public HibernateSessionHolder hibernateSessionHolder() {
        return new HibernateSessionHolderImpl();
    }

    @ConditionalOnExpression(value="@moduleSettings.createUnitOfWorkFactory")
    @Bean
    @Exposed
    public UnitOfWorkFactory unitOfWork(SessionFactory sessionFactory) {
        return new UnitOfWorkFactoryImpl(Collections.singleton(sessionFactory));
    }

    @EventListener
    protected void registerClientModuleRepositoryInterceptors(AcrossModuleBeforeBootstrapEvent beforeBootstrapEvent) {
        if (this.settings.isRegisterRepositoryInterceptor()) {
            LOG.trace("Enabling BasicRepositoryInterceptor support in module {}", (Object)beforeBootstrapEvent.getModule().getName());
            beforeBootstrapEvent.getBootstrapConfig().addApplicationContextConfigurer(true, new Class[]{ModuleBasicRepositoryInterceptorConfiguration.class});
        }
        LOG.trace("Enabling @Transaction support in module {}", (Object)beforeBootstrapEvent.getModule().getName());
        beforeBootstrapEvent.getBootstrapConfig().addApplicationContextConfigurer(true, new Class[]{EnableTransactionManagementConfiguration.class, PersistenceExceptionTranslationAutoConfiguration.class});
    }
}

