/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.config;

import com.foreach.across.core.DynamicAcrossModule;
import com.foreach.across.core.annotations.Module;
import com.foreach.across.core.context.info.AcrossContextInfo;
import com.foreach.across.core.context.info.AcrossModuleInfo;
import com.foreach.across.modules.hibernate.AbstractHibernatePackageModule;
import com.foreach.across.modules.hibernate.AcrossHibernateModuleSettings;
import com.foreach.across.modules.hibernate.provider.HibernatePackage;
import com.foreach.across.modules.hibernate.provider.HibernatePackageConfigurer;
import java.util.HashSet;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HibernatePackageBuilder
extends AbstractFactoryBean<HibernatePackage> {
    private final AcrossContextInfo contextInfo;
    private final AbstractHibernatePackageModule currentModule;
    private final AcrossHibernateModuleSettings moduleSettings;

    @Autowired
    public HibernatePackageBuilder(AcrossContextInfo contextInfo, @Module(value="across.currentModule") AbstractHibernatePackageModule currentModule, AcrossHibernateModuleSettings moduleSettings) {
        this.contextInfo = contextInfo;
        this.currentModule = currentModule;
        this.moduleSettings = moduleSettings;
    }

    public Class<?> getObjectType() {
        return HibernatePackage.class;
    }

    protected HibernatePackage createInstance() {
        HibernatePackage hibernatePackage = new HibernatePackage(this.currentModule.getName());
        this.currentModule.getHibernatePackageProviders().forEach(hibernatePackage::add);
        if (this.currentModule.isScanForHibernatePackages()) {
            HashSet configurers = new HashSet();
            this.contextInfo.getModules().stream().filter(acrossModuleInfo -> acrossModuleInfo.getModule() instanceof HibernatePackageConfigurer).forEach(acrossModuleInfo -> configurers.add((HibernatePackageConfigurer)acrossModuleInfo.getModule()));
            ((ListableBeanFactory)this.getBeanFactory()).getBeansOfType(HibernatePackageConfigurer.class).forEach((name, configurer) -> configurers.add(configurer));
            configurers.forEach(c -> c.configureHibernatePackage(hibernatePackage));
        }
        EntityScanPackages.get((BeanFactory)this.currentModule.getAcrossApplicationContextHolder().getApplicationContext()).getPackageNames().forEach(xva$0 -> hibernatePackage.addPackageToScan((String)xva$0));
        if (this.moduleSettings.getApplicationModule().isEntityScan()) {
            this.registerDynamicApplicationPackage(hibernatePackage);
        }
        return hibernatePackage;
    }

    private void registerDynamicApplicationPackage(HibernatePackage hibernatePackage) {
        this.contextInfo.getModules().stream().map(AcrossModuleInfo::getModule).filter(DynamicAcrossModule.DynamicApplicationModule.class::isInstance).map(DynamicAcrossModule.DynamicApplicationModule.class::cast).findFirst().ifPresent(module -> hibernatePackage.addPackageToScan(module.getBasePackage()));
    }
}

