/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.config;

import com.foreach.across.core.annotations.Module;
import com.foreach.across.core.context.AcrossListableBeanFactory;
import com.foreach.across.core.context.info.AcrossContextInfo;
import com.foreach.across.core.context.info.AcrossModuleInfo;
import com.foreach.across.modules.hibernate.AbstractHibernatePackageModule;
import com.foreach.across.modules.hibernate.AcrossHibernateModuleSettings;
import com.foreach.across.modules.hibernate.extensions.HibernatePersistenceContextInViewConfiguration;
import com.foreach.across.modules.hibernate.jpa.AcrossHibernateJpaModuleSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.transaction.PlatformTransactionManager;

@Order(value=-2147483648)
public class ModuleSettingsRegistrar
implements ImportSelector,
BeanFactoryAware,
EnvironmentAware {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleSettingsRegistrar.class);
    public static final String BEAN_NAME = "moduleSettings";
    private Environment environment;
    private BeanFactory beanFactory;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public final String[] selectImports(AnnotationMetadata importingClassMetadata) {
        AcrossListableBeanFactory lbf = (AcrossListableBeanFactory)this.beanFactory;
        String beanName = "across.currentModuleSettings";
        AcrossHibernateModuleSettings moduleSettings = new ModuleSettingsFactory((AcrossContextInfo)lbf.getParentBeanFactory().getBean(AcrossContextInfo.class), (AbstractHibernatePackageModule)((Object)lbf.getBean("across.currentModule")), this.environment).createInstance();
        if (!lbf.containsBeanDefinition(beanName)) {
            GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
            beanDefinition.setBeanClass(((Object)((Object)moduleSettings)).getClass());
            beanDefinition.setPrimary(true);
            beanDefinition.addQualifier(new AutowireCandidateQualifier(Module.class.getName(), (Object)"across.currentModule"));
            lbf.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        }
        lbf.registerSingleton(beanName, (Object)moduleSettings);
        lbf.registerAlias(beanName, BEAN_NAME);
        return this.settingsDependantImports();
    }

    protected String[] settingsDependantImports() {
        return new String[]{HibernatePersistenceContextInViewConfiguration.class.getName()};
    }

    static class ModuleSettingsFactory {
        private final AcrossContextInfo contextInfo;
        private final AbstractHibernatePackageModule currentModule;
        private final Environment environment;

        AcrossHibernateModuleSettings createInstance() {
            AcrossHibernateModuleSettings moduleSettings = this.currentModule.createSettings();
            this.applyDefaultValues(moduleSettings);
            if (this.isDefaultHibernateModule()) {
                this.bindProperties("spring.jpa", (Object)moduleSettings);
                this.bindProperties("spring.jpa.hibernate", moduleSettings.getHibernate());
                this.bindProperties("spring.transaction", moduleSettings.getTransactionProperties());
                moduleSettings.getApplicationModule().setRepositoryScan((Boolean)this.environment.getProperty("spring.data.jpa.repositories.enabled", Boolean.TYPE, (Object)moduleSettings.getApplicationModule().isRepositoryScan()));
            }
            String modulePrefix = this.currentModule.getPropertiesPrefix();
            this.bindProperties(modulePrefix, (Object)moduleSettings);
            this.bindProperties(modulePrefix + ".transaction", moduleSettings.getTransactionProperties());
            this.bindProperties(modulePrefix + ".hibernate", moduleSettings.getHibernate());
            this.bindProperties(modulePrefix + ".application", moduleSettings.getApplicationModule());
            return moduleSettings;
        }

        private void bindProperties(String prefix, Object target) {
            Binder binder = Binder.get((Environment)this.environment);
            binder.bind(prefix, Bindable.ofInstance((Object)target));
        }

        private void applyDefaultValues(AcrossHibernateModuleSettings moduleSettings) {
            boolean scanDefaults = this.isDefaultHibernateModule() && this.isSingleHibernateModule();
            moduleSettings.setDataSource(this.currentModule.getDataSourceName());
            moduleSettings.getApplicationModule().setEntityScan(scanDefaults);
            moduleSettings.getApplicationModule().setRepositoryScan(scanDefaults);
            moduleSettings.setGenerateDdl(false);
            moduleSettings.getHibernate().setDdlAuto("none");
            if (moduleSettings instanceof AcrossHibernateJpaModuleSettings) {
                AcrossHibernateJpaModuleSettings jpaModuleSettings = (AcrossHibernateJpaModuleSettings)moduleSettings;
                jpaModuleSettings.setPersistenceUnitName(this.currentModule.getName());
                if (this.isSingleHibernateModule() && BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.contextInfo.getApplicationContext(), PlatformTransactionManager.class).isEmpty()) {
                    LOG.trace("Switching to default primary as this is the only AcrossHibernateJpaModule and there are no other transaction managers");
                    jpaModuleSettings.setPrimary(true);
                }
            }
        }

        private boolean isDefaultHibernateModule() {
            return "AcrossHibernateJpaModule".equals(this.currentModule.getName());
        }

        private boolean isSingleHibernateModule() {
            return this.contextInfo.getModules().stream().map(AcrossModuleInfo::getModule).filter(AbstractHibernatePackageModule.class::isInstance).count() == 1L;
        }

        public ModuleSettingsFactory(AcrossContextInfo contextInfo, AbstractHibernatePackageModule currentModule, Environment environment) {
            this.contextInfo = contextInfo;
            this.currentModule = currentModule;
            this.environment = environment;
        }
    }
}

