/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.extensions;

import com.foreach.across.core.AcrossModule;
import com.foreach.across.core.annotations.ConditionalOnAcrossModule;
import com.foreach.across.core.annotations.Module;
import com.foreach.across.modules.hibernate.AcrossHibernateModuleSettings;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.orm.hibernate5.support.OpenSessionInViewFilter;
import org.springframework.orm.hibernate5.support.OpenSessionInViewInterceptor;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ConditionalOnAcrossModule(value={"AcrossWebModule"})
@Configuration
public class HibernatePersistenceContextInViewConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(HibernatePersistenceContextInViewConfiguration.class);

    @Configuration
    @ConditionalOnExpression(value="true == @moduleSettings.openInView and @moduleSettings.persistenceContextInView.handler.name() == 'INTERCEPTOR'")
    public static class OpenSessionFactoryInViewInterceptorConfiguration
    implements WebMvcConfigurer,
    Ordered {
        @Autowired
        private SessionFactory sessionFactory;
        @Autowired
        @Module(value="across.currentModule")
        private AcrossHibernateModuleSettings settings;

        public int getOrder() {
            return this.settings.getPersistenceContextInView().getOrder();
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addWebRequestInterceptor((WebRequestInterceptor)this.openSessionInViewInterceptor());
        }

        @Bean
        public OpenSessionInViewInterceptor openSessionInViewInterceptor() {
            OpenSessionInViewInterceptor interceptor = new OpenSessionInViewInterceptor();
            interceptor.setSessionFactory(this.sessionFactory);
            return interceptor;
        }
    }

    @Configuration
    @ConditionalOnExpression(value="true == @moduleSettings.openInView and @moduleSettings.persistenceContextInView.handler.name() == 'FILTER'")
    public static class OpenSessionFactoryInViewFilterConfiguration {
        @Autowired
        private SessionFactory sessionFactory;
        @Autowired
        @Module(value="across.currentModule")
        private AcrossModule currentModule;

        @Bean
        public OpenSessionInViewFilter openSessionInViewFilter() {
            return new OpenSessionInViewFilter(){

                protected SessionFactory lookupSessionFactory() {
                    return sessionFactory;
                }
            };
        }

        @Bean
        public FilterRegistrationBean<OpenSessionInViewFilter> openEntityManagerInViewFilterFilterRegistrationBean() {
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setName(this.currentModule.getName() + ".OpenSessionInViewFilter");
            registrationBean.setFilter((Filter)this.openSessionInViewFilter());
            registrationBean.setAsyncSupported(true);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST, DispatcherType.ERROR, DispatcherType.ASYNC));
            registrationBean.addUrlPatterns(new String[]{"/*"});
            return registrationBean;
        }
    }
}

