/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.extensions;

import com.foreach.across.core.AcrossModule;
import com.foreach.across.core.annotations.ConditionalOnAcrossModule;
import com.foreach.across.core.annotations.Module;
import com.foreach.across.modules.hibernate.AcrossHibernateModuleSettings;
import java.util.EnumSet;
import javax.persistence.EntityManagerFactory;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.orm.jpa.support.OpenEntityManagerInViewFilter;
import org.springframework.orm.jpa.support.OpenEntityManagerInViewInterceptor;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ConditionalOnAcrossModule(value={"AcrossWebModule"})
@Configuration
public class JpaPersistenceContextInViewConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(JpaPersistenceContextInViewConfiguration.class);

    @Configuration
    @ConditionalOnExpression(value="true == @moduleSettings.openInView and @moduleSettings.persistenceContextInView.handler.name() == 'INTERCEPTOR'")
    public static class OpenEntityManagerInViewInterceptorConfiguration
    implements WebMvcConfigurer,
    Ordered {
        @Autowired
        private EntityManagerFactory entityManagerFactory;
        @Autowired
        @Module(value="across.currentModule")
        private AcrossHibernateModuleSettings settings;

        public int getOrder() {
            return this.settings.getPersistenceContextInView().getOrder();
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addWebRequestInterceptor((WebRequestInterceptor)this.openEntityManagerInViewInterceptor());
        }

        @Bean
        public OpenEntityManagerInViewInterceptor openEntityManagerInViewInterceptor() {
            OpenEntityManagerInViewInterceptor interceptor = new OpenEntityManagerInViewInterceptor();
            interceptor.setEntityManagerFactory(this.entityManagerFactory);
            return interceptor;
        }
    }

    @Configuration
    @ConditionalOnExpression(value="true == @moduleSettings.openInView and @moduleSettings.persistenceContextInView.handler.name() == 'FILTER'")
    public static class OpenEntityManagerInViewFilterConfiguration {
        @Autowired
        private EntityManagerFactory entityManagerFactory;
        @Autowired
        @Module(value="across.currentModule")
        private AcrossModule currentModule;

        @Bean
        public FilterRegistrationBean<OpenEntityManagerInViewFilter> openEntityManagerInViewFilterFilterRegistrationBean() {
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setName(this.currentModule.getName() + ".OpenEntityManagerInViewFilter");
            registrationBean.setFilter((Filter)this.openEntityManagerInViewFilter());
            registrationBean.setAsyncSupported(true);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST, DispatcherType.ERROR, DispatcherType.ASYNC));
            registrationBean.addUrlPatterns(new String[]{"/*"});
            return registrationBean;
        }

        @Bean
        public OpenEntityManagerInViewFilter openEntityManagerInViewFilter() {
            return new OpenEntityManagerInViewFilter(){

                protected EntityManagerFactory lookupEntityManagerFactory() {
                    return entityManagerFactory;
                }
            };
        }
    }
}

