/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.id;

import com.foreach.across.modules.hibernate.business.SettableIdBasedEntity;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.enhanced.StandardOptimizerDescriptor;
import org.hibernate.id.enhanced.TableGenerator;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;

public class AcrossSequenceGenerator
extends TableGenerator {
    public static final String STRATEGY = "com.foreach.across.modules.hibernate.id.AcrossSequenceGenerator";
    private String entityName;
    private boolean supportPredefinedIds = true;

    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) throws MappingException {
        this.entityName = params.getProperty("entity_name");
        if (this.entityName == null) {
            throw new MappingException("no entity name");
        }
        String pkColumnValue = params.getProperty("sequenceName");
        if (StringUtils.isBlank((CharSequence)pkColumnValue)) {
            throw new MappingException("A sequenceName is required for a Across sequence generator");
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)params);
        props.put("schema", "");
        props.put("catalog", "");
        props.put("prefer_entity_table_as_segment_value", "true");
        props.put("table_name", "across_sequences");
        props.put("segment_column_name", "seq_name");
        props.put("segment_value", pkColumnValue);
        props.put("value_column_name", "seq_number");
        props.put("optimizer", StandardOptimizerDescriptor.POOLED_LO.getExternalName());
        if (params.containsKey("optimizer")) {
            props.put("optimizer", params.getProperty("optimizer"));
        }
        int allocationSize = this.determineAllocationSize(params, 50);
        props.put("increment_size", String.valueOf(allocationSize));
        props.put("initial_value", String.valueOf(this.determineInitialValue(params, 1)));
        if (params.containsKey("supportPredefinedIds")) {
            this.supportPredefinedIds = Boolean.valueOf(params.getProperty("supportPredefinedIds"));
        }
        super.configure(type, props, serviceRegistry);
    }

    private int determineAllocationSize(Properties params, int defaultAllocationSize) {
        if (params.containsKey("allocationSize")) {
            return Integer.valueOf(params.getProperty("allocationSize"));
        }
        return defaultAllocationSize;
    }

    private int determineInitialValue(Properties params, int defaultInitialValue) {
        if (params.containsKey("initialValue")) {
            int initialValue = Integer.valueOf(params.getProperty("initialValue"));
            return initialValue < defaultInitialValue ? defaultInitialValue : initialValue;
        }
        return defaultInitialValue;
    }

    public Serializable generate(SharedSessionContractImplementor session, Object object) {
        Serializable id = session.getEntityPersister(this.entityName, object).getClassMetadata().getIdentifier(object, session);
        if (this.supportPredefinedIds) {
            if (id != null && !Long.valueOf(0L).equals(id)) {
                return id;
            }
            if (object instanceof SettableIdBasedEntity && (id = ((SettableIdBasedEntity)object).getNewEntityId()) != null && !Long.valueOf(0L).equals(id)) {
                return id;
            }
        }
        return super.generate(session, object);
    }
}

