/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.installers;

import com.foreach.across.core.annotations.InstallerGroup;
import com.foreach.across.core.annotations.InstallerMethod;
import com.foreach.across.core.annotations.Module;
import com.foreach.across.core.context.info.AcrossModuleInfo;
import com.foreach.across.core.context.support.ModuleBeanSelectorUtils;
import com.foreach.across.core.database.SchemaConfiguration;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.sql.DataSource;
import liquibase.exception.LiquibaseException;
import liquibase.integration.spring.SpringLiquibase;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ResourceLoader;

@InstallerGroup(value="schema")
public abstract class AuditableSchemaInstaller {
    private static final String CHANGELOG = "classpath:com/foreach/across/modules/hibernate/installers/AuditableSchemaInstaller.xml";
    private static final Logger LOG = LoggerFactory.getLogger(AuditableSchemaInstaller.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Module(value="across.currentModule")
    private AcrossModuleInfo moduleInfo;
    @Autowired
    @Qualifier(value="acrossInstallerDataSource")
    private DataSource dataSource;
    private SchemaConfiguration schemaConfiguration;
    private String defaultSchema;

    public AuditableSchemaInstaller() {
    }

    protected AuditableSchemaInstaller(SchemaConfiguration schemaConfiguration) {
        this.schemaConfiguration = schemaConfiguration;
    }

    protected abstract Collection<String> getTableNames();

    protected SchemaConfiguration getSchemaConfiguration() {
        return this.schemaConfiguration;
    }

    protected void setSchemaConfiguration(SchemaConfiguration schemaConfiguration) {
        this.schemaConfiguration = schemaConfiguration;
    }

    protected void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    protected String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected DataSource getDataSource() {
        return this.dataSource;
    }

    protected void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Autowired
    protected void setBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        if (this.schemaConfiguration == null) {
            Optional schemaConfigurationOptional = ModuleBeanSelectorUtils.selectBeanForModule(SchemaConfiguration.class, (String)this.moduleInfo.getName(), (ConfigurableListableBeanFactory)beanFactory);
            schemaConfigurationOptional.ifPresent(this::setSchemaConfiguration);
        }
    }

    @InstallerMethod
    public void install() throws LiquibaseException {
        for (String tableName : this.getTableNames()) {
            String tableNameToUse = this.schemaConfiguration != null ? this.schemaConfiguration.getCurrentTableName(tableName) : tableName;
            SpringLiquibase liquibase = new SpringLiquibase();
            if (liquibase.getResourceLoader() == null) {
                liquibase.setResourceLoader((ResourceLoader)this.applicationContext);
            }
            liquibase.setChangeLog(CHANGELOG);
            if (StringUtils.isNotEmpty((CharSequence)this.getDefaultSchema())) {
                liquibase.setDefaultSchema(this.getDefaultSchema());
            } else if (this.getSchemaConfiguration() != null) {
                liquibase.setDefaultSchema(this.getSchemaConfiguration().getDefaultSchema());
            }
            liquibase.setDataSource(this.dataSource);
            liquibase.setChangeLogParameters(Collections.singletonMap("table.auditable_table", tableNameToUse));
            LOG.debug("Installing auditable columns for table {}", (Object)tableNameToUse);
            liquibase.afterPropertiesSet();
        }
    }
}

