/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.jpa;

import com.foreach.across.core.annotations.AcrossDepends;
import com.foreach.across.core.annotations.AcrossRole;
import com.foreach.across.core.context.AcrossModuleRole;
import com.foreach.across.core.context.bootstrap.AcrossBootstrapConfig;
import com.foreach.across.core.context.bootstrap.ModuleBootstrapConfig;
import com.foreach.across.core.context.configurer.ApplicationContextConfigurer;
import com.foreach.across.core.context.configurer.ComponentScanConfigurer;
import com.foreach.across.core.transformers.BeanDefinitionTransformerComposite;
import com.foreach.across.core.transformers.BeanPrefixingTransformer;
import com.foreach.across.core.transformers.ExposedBeanDefinitionTransformer;
import com.foreach.across.modules.hibernate.AbstractHibernatePackageModule;
import com.foreach.across.modules.hibernate.jpa.AcrossHibernateJpaModuleSettings;
import com.foreach.across.modules.hibernate.jpa.config.PrimaryTransactionManagerTransformer;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AcrossRole(value=AcrossModuleRole.INFRASTRUCTURE)
@AcrossDepends(optional={"EhcacheModule"})
public class AcrossHibernateJpaModule
extends AbstractHibernatePackageModule {
    private static final Logger LOG = LoggerFactory.getLogger(AcrossHibernateJpaModule.class);
    public static final String NAME = "AcrossHibernateJpaModule";
    private String moduleName = "AcrossHibernateJpaModule";

    public AcrossHibernateJpaModule() {
        this.setPropertiesPrefix(NAME.equals(this.getName()) ? "across-hibernate" : null);
        this.setPersistenceUnitName(this.getName());
        this.setHibernateProperty("hibernate.cache.use_second_level_cache", "false");
    }

    public AcrossHibernateJpaModule(DataSource dataSource) {
        this();
        this.setDataSource(dataSource);
    }

    public String getName() {
        return this.moduleName;
    }

    void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getDescription() {
        return "Enables JPA support on the Across context using Hibernate as the vendor implementation.";
    }

    protected final void setPersistenceUnitName(String persistenceUnitName) {
        this.setProperty(this.getPropertiesPrefix() + ".persistenceUnitName", persistenceUnitName);
    }

    public final void setPrimary(Boolean primary) {
        if (primary != null) {
            this.setProperty(this.getPropertiesPrefix() + ".primary", primary);
        } else {
            this.getProperties().remove(this.getPropertiesPrefix() + ".primary");
        }
    }

    @Override
    public AcrossHibernateJpaModuleSettings createSettings() {
        return new AcrossHibernateJpaModuleSettings();
    }

    protected void registerDefaultApplicationContextConfigurers(Set<ApplicationContextConfigurer> contextConfigurers) {
        contextConfigurers.add((ApplicationContextConfigurer)new ComponentScanConfigurer(new String[]{AcrossHibernateJpaModule.class.getPackage().getName() + ".config"}));
    }

    public void prepareForBootstrap(ModuleBootstrapConfig currentModule, AcrossBootstrapConfig contextConfig) {
        if (this.getName().equals(currentModule.getModuleName())) {
            if (currentModule.getExposeTransformer() != null) {
                currentModule.setExposeTransformer((ExposedBeanDefinitionTransformer)new BeanDefinitionTransformerComposite(new ExposedBeanDefinitionTransformer[]{currentModule.getExposeTransformer(), new PrimaryTransactionManagerTransformer(this)}));
            } else {
                currentModule.setExposeTransformer((ExposedBeanDefinitionTransformer)new PrimaryTransactionManagerTransformer(this));
            }
        }
    }

    public static AcrossHibernateJpaModuleBuilder builder() {
        return new AcrossHibernateJpaModuleBuilder();
    }

    public static class AcrossHibernateJpaModuleBuilder {
        private String prefix;
        private String moduleName;
        private String exposePrefix;
        private String propertiesPrefix;
        private boolean primary;
        private DataSource dataSource;
        private String dataSourceName;
        private String persistenceUnitName;

        public AcrossHibernateJpaModule build() {
            AcrossHibernateJpaModule module = new AcrossHibernateJpaModule();
            String prefix = this.prefix;
            String propertiesSuffix = ".jpa";
            if (prefix == null) {
                LOG.trace("No module prefix configured, attempting to use module name as prefix: {}", (Object)this.moduleName);
                prefix = this.moduleName;
                propertiesSuffix = "";
            }
            if (prefix == null) {
                throw new IllegalArgumentException("You need a default prefix or module name to generate an AcrossHibernateJpaModule");
            }
            module.setModuleName(StringUtils.defaultString((String)this.moduleName, (String)StringUtils.capitalize((String)(prefix + "JpaModule"))));
            module.setPropertiesPrefix(StringUtils.defaultString((String)this.propertiesPrefix, (String)(StringUtils.uncapitalize((String)prefix) + propertiesSuffix)));
            module.setDataSource(this.dataSource);
            module.setDataSourceName(StringUtils.defaultString((String)this.dataSourceName, (String)StringUtils.uncapitalize((String)(prefix + "DataSource"))));
            module.setPersistenceUnitName(StringUtils.defaultString((String)this.persistenceUnitName, (String)module.getName()));
            module.setPrimary(this.primary);
            String actualExposePrefix = StringUtils.defaultString((String)this.exposePrefix, (String)StringUtils.uncapitalize((String)prefix));
            module.setExposeTransformer((ExposedBeanDefinitionTransformer)new BeanPrefixingTransformer(actualExposePrefix));
            LOG.info("Built AcrossHibernateJpaModule with name: {}, properties prefix: {}, expose prefix: {}, data source bean: {}", new Object[]{module.getName(), module.getPropertiesPrefix(), actualExposePrefix, module.getDataSourceName()});
            return module;
        }

        public AcrossHibernateJpaModuleBuilder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public AcrossHibernateJpaModuleBuilder moduleName(String moduleName) {
            this.moduleName = moduleName;
            return this;
        }

        public AcrossHibernateJpaModuleBuilder exposePrefix(String exposePrefix) {
            this.exposePrefix = exposePrefix;
            return this;
        }

        public AcrossHibernateJpaModuleBuilder propertiesPrefix(String propertiesPrefix) {
            this.propertiesPrefix = propertiesPrefix;
            return this;
        }

        public AcrossHibernateJpaModuleBuilder primary(boolean primary) {
            this.primary = primary;
            return this;
        }

        public AcrossHibernateJpaModuleBuilder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public AcrossHibernateJpaModuleBuilder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public AcrossHibernateJpaModuleBuilder persistenceUnitName(String persistenceUnitName) {
            this.persistenceUnitName = persistenceUnitName;
            return this;
        }
    }
}

