/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.jpa.aop;

import com.foreach.across.modules.hibernate.aop.EntityInterceptor;
import com.foreach.across.modules.hibernate.jpa.aop.JpaRepositoryPointcut;
import com.foreach.across.modules.hibernate.support.TransactionWrapper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hibernate.Hibernate;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.domain.Persistable;
import org.springframework.data.repository.CrudRepository;
import org.springframework.util.ClassUtils;

public abstract class AbstractCrudRepositoryInterceptor
implements MethodInterceptor,
BeanFactoryAware {
    static final String SAVE = "save";
    static final String SAVE_ALL = "saveAll";
    static final String DELETE = "delete";
    static final String DELETE_ALL = "deleteAll";
    private final Collection<EntityInterceptor> interceptors;
    private BeanFactory beanFactory;
    private TransactionWrapper transactionWrapper = null;

    protected AbstractCrudRepositoryInterceptor(Collection<EntityInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setTransactionManagerName(String transactionManagerName) {
        if (transactionManagerName != null) {
            this.transactionWrapper = new TransactionWrapper();
            this.transactionWrapper.setTransactionManagerBeanName(transactionManagerName);
            this.transactionWrapper.setBeanFactory(this.beanFactory);
            this.transactionWrapper.afterPropertiesSet();
        } else {
            transactionManagerName = null;
        }
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        TransactionWrapper.InvocationCallback<Object> handler;
        Method method = invocation.getMethod();
        if (JpaRepositoryPointcut.isEntityMethod(method) && (handler = this.determineCallbackMethod(invocation)) != null) {
            if (this.transactionWrapper != null) {
                return this.transactionWrapper.invokeWithinTransaction(handler);
            }
            return handler.invoke();
        }
        return invocation.proceed();
    }

    protected TransactionWrapper.InvocationCallback<Object> determineCallbackMethod(MethodInvocation invocation) {
        String methodName;
        Class<?> entityClass = this.getEntityClass(invocation);
        Method method = invocation.getMethod();
        Object[] arguments = invocation.getArguments();
        switch (methodName = method.getName()) {
            case "deleteAll": {
                return () -> {
                    if (arguments.length == 0) {
                        Collection<EntityInterceptor> interceptorsForDeleteAll = this.findInterceptorsToApply(entityClass, this.getInterceptors());
                        this.callBeforeDeleteAll(interceptorsForDeleteAll, entityClass);
                        Object returnValueForDeleteAll = invocation.proceed();
                        this.callAfterDeleteAll(interceptorsForDeleteAll, entityClass);
                        return returnValueForDeleteAll;
                    }
                    Object entityObject = arguments[0];
                    Collection<EntityInterceptor> interceptorsForDelete = this.findInterceptorsToApply(entityClass, this.getInterceptors());
                    for (Object o : (Iterable)entityObject) {
                        this.callBeforeDelete(interceptorsForDelete, o);
                    }
                    Object returnValueForDelete = invocation.proceed();
                    for (Object o : (Iterable)entityObject) {
                        this.callAfterDelete(interceptorsForDelete, o);
                    }
                    return returnValueForDelete;
                };
            }
            case "delete": {
                return () -> {
                    Object entityObject = arguments[0];
                    Class<?> targetClass = method.getParameterTypes()[0];
                    Class userClass = ClassUtils.getUserClass(targetClass);
                    if (Iterable.class.isAssignableFrom(userClass)) {
                        Collection<EntityInterceptor> interceptorsForDelete = this.findInterceptorsToApply(entityClass, this.getInterceptors());
                        for (Object o : (Iterable)entityObject) {
                            this.callBeforeDelete(interceptorsForDelete, o);
                        }
                        Object returnValueForDelete = invocation.proceed();
                        for (Object o : (Iterable)entityObject) {
                            this.callAfterDelete(interceptorsForDelete, o);
                        }
                        return returnValueForDelete;
                    }
                    Class entityClassForDelete = ClassUtils.getUserClass((Class)Hibernate.getClass((Object)entityObject));
                    Collection<EntityInterceptor> interceptorsForDelete = this.findInterceptorsToApply(entityClassForDelete, this.getInterceptors());
                    this.callBeforeDelete(interceptorsForDelete, entityObject);
                    Object returnValueForDelete = invocation.proceed();
                    this.callAfterDelete(interceptorsForDelete, entityObject);
                    return returnValueForDelete;
                };
            }
            case "save": 
            case "saveAll": {
                return () -> {
                    Object objectToSave = arguments[0];
                    Class<?> targetClassToSave = method.getParameterTypes()[0];
                    Class userClassToSave = ClassUtils.getUserClass(targetClassToSave);
                    if (Iterable.class.isAssignableFrom(userClassToSave)) {
                        IdentityHashMap<Persistable, Boolean> objects = new IdentityHashMap<Persistable, Boolean>();
                        Collection<EntityInterceptor> interceptors1 = this.findInterceptorsToApply(entityClass, this.getInterceptors());
                        for (Object t : (Iterable)objectToSave) {
                            boolean bl = ((Persistable)t).isNew();
                            objects.put((Persistable)t, bl);
                        }
                        for (Map.Entry entry : objects.entrySet()) {
                            Boolean bl = (Boolean)entry.getValue();
                            if (bl.booleanValue()) {
                                this.callBeforeCreate(interceptors1, entry.getKey());
                                continue;
                            }
                            this.callBeforeUpdate(interceptors1, entry.getKey());
                        }
                        Object returnValueForSave = invocation.proceed();
                        for (Map.Entry entry : objects.entrySet()) {
                            Boolean forCreate = (Boolean)entry.getValue();
                            if (forCreate.booleanValue()) {
                                this.callAfterCreate(interceptors1, entry.getKey());
                                continue;
                            }
                            this.callAfterUpdate(interceptors1, entry.getKey());
                        }
                        return returnValueForSave;
                    }
                    Class entityClassForSave = ClassUtils.getUserClass((Class)Hibernate.getClass((Object)objectToSave));
                    Collection<EntityInterceptor> interceptorsForSave = this.findInterceptorsToApply(entityClassForSave, this.getInterceptors());
                    boolean isNew = ((Persistable)objectToSave).isNew();
                    if (isNew) {
                        this.callBeforeCreate(interceptorsForSave, objectToSave);
                    } else {
                        this.callBeforeUpdate(interceptorsForSave, objectToSave);
                    }
                    Object object = invocation.proceed();
                    if (isNew) {
                        this.callAfterCreate(interceptorsForSave, objectToSave);
                    } else {
                        this.callAfterUpdate(interceptorsForSave, objectToSave);
                    }
                    return object;
                };
            }
        }
        return null;
    }

    protected Class<?> getEntityClass(MethodInvocation invocation) {
        Object target = invocation instanceof ProxyMethodInvocation ? ((ProxyMethodInvocation)invocation).getProxy() : invocation.getThis();
        return TypeDescriptor.forObject((Object)target).upcast(CrudRepository.class).getResolvableType().getGeneric(new int[]{0}).resolve();
    }

    protected Collection<EntityInterceptor> findInterceptorsToApply(Class<?> entityClass, Collection<EntityInterceptor> interceptors) {
        ArrayList<EntityInterceptor> matchingInterceptors = new ArrayList<EntityInterceptor>();
        for (EntityInterceptor candidate : interceptors) {
            if (!candidate.handles(entityClass)) continue;
            matchingInterceptors.add(candidate);
        }
        return matchingInterceptors;
    }

    public void callBeforeCreate(Collection<EntityInterceptor> interceptors, Object entity) {
        for (EntityInterceptor interceptor : interceptors) {
            interceptor.beforeCreate(entity);
        }
    }

    public void callAfterCreate(Collection<EntityInterceptor> interceptors, Object entity) {
        for (EntityInterceptor interceptor : interceptors) {
            interceptor.afterCreate(entity);
        }
    }

    public void callBeforeUpdate(Collection<EntityInterceptor> interceptors, Object entity) {
        for (EntityInterceptor interceptor : interceptors) {
            interceptor.beforeUpdate(entity);
        }
    }

    public void callAfterUpdate(Collection<EntityInterceptor> interceptors, Object entity) {
        for (EntityInterceptor interceptor : interceptors) {
            interceptor.afterUpdate(entity);
        }
    }

    public void callBeforeDelete(Collection<EntityInterceptor> interceptors, Object entity) {
        for (EntityInterceptor interceptor : interceptors) {
            interceptor.beforeDelete(entity);
        }
    }

    public void callAfterDelete(Collection<EntityInterceptor> interceptors, Object entity) {
        for (EntityInterceptor interceptor : interceptors) {
            interceptor.afterDelete(entity);
        }
    }

    public void callBeforeDeleteAll(Collection<EntityInterceptor> interceptors, Class entityClass) {
        for (EntityInterceptor interceptor : interceptors) {
            interceptor.beforeDeleteAll(entityClass);
        }
    }

    public void callAfterDeleteAll(Collection<EntityInterceptor> interceptors, Class entityClass) {
        for (EntityInterceptor interceptor : interceptors) {
            interceptor.afterDeleteAll(entityClass);
        }
    }

    public Collection<EntityInterceptor> getInterceptors() {
        return this.interceptors;
    }
}

