/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.jpa.aop;

import com.foreach.across.modules.hibernate.aop.EntityInterceptor;
import com.foreach.across.modules.hibernate.jpa.aop.AbstractCrudRepositoryInterceptor;
import com.foreach.across.modules.hibernate.support.TransactionWrapper;
import java.lang.reflect.Method;
import java.util.Collection;
import org.aopalliance.intercept.MethodInvocation;
import org.hibernate.Hibernate;
import org.springframework.data.domain.Persistable;
import org.springframework.util.ClassUtils;

public class JpaRepositoryInterceptor
extends AbstractCrudRepositoryInterceptor {
    static final String SAVE_AND_FLUSH = "saveAndFlush";
    static final String DELETE_IN_BATCH = "deleteInBatch";
    static final String DELETE_ALL_IN_BATCH = "deleteAllInBatch";

    public JpaRepositoryInterceptor(Collection<EntityInterceptor> interceptors) {
        super(interceptors);
    }

    @Override
    protected TransactionWrapper.InvocationCallback<Object> determineCallbackMethod(MethodInvocation invocation) {
        TransactionWrapper.InvocationCallback<Object> handler = super.determineCallbackMethod(invocation);
        if (handler == null) {
            Method method = invocation.getMethod();
            Object[] arguments = invocation.getArguments();
            String methodName = method.getName();
            if (DELETE_ALL_IN_BATCH.equalsIgnoreCase(methodName)) {
                handler = () -> {
                    Class<?> entityClass = this.getEntityClass(invocation);
                    Collection<EntityInterceptor> interceptors = this.findInterceptorsToApply(entityClass, this.getInterceptors());
                    this.callBeforeDeleteAll(interceptors, entityClass);
                    Object returnValue = invocation.proceed();
                    this.callAfterDeleteAll(interceptors, entityClass);
                    return returnValue;
                };
            } else if (DELETE_IN_BATCH.equalsIgnoreCase(methodName)) {
                handler = () -> {
                    Class<?> entityClassForDelete = this.getEntityClass(invocation);
                    Collection<EntityInterceptor> interceptorsForDelete = this.findInterceptorsToApply(entityClassForDelete, this.getInterceptors());
                    for (Object o : (Iterable)arguments[0]) {
                        this.callBeforeDelete(interceptorsForDelete, o);
                    }
                    Object returnValueForDelete = invocation.proceed();
                    for (Object o : (Iterable)arguments[0]) {
                        this.callAfterDelete(interceptorsForDelete, o);
                    }
                    return returnValueForDelete;
                };
            } else if (SAVE_AND_FLUSH.equalsIgnoreCase(methodName)) {
                handler = () -> {
                    Object objectToSave = arguments[0];
                    Class entityClassForSave = ClassUtils.getUserClass((Class)Hibernate.getClass((Object)objectToSave));
                    Collection<EntityInterceptor> interceptorsForSave = this.findInterceptorsToApply(entityClassForSave, this.getInterceptors());
                    boolean isNew = ((Persistable)objectToSave).isNew();
                    if (isNew) {
                        this.callBeforeCreate(interceptorsForSave, objectToSave);
                    } else {
                        this.callBeforeUpdate(interceptorsForSave, objectToSave);
                    }
                    Object returnValueForSave = invocation.proceed();
                    if (isNew) {
                        this.callAfterCreate(interceptorsForSave, objectToSave);
                    } else {
                        this.callAfterUpdate(interceptorsForSave, objectToSave);
                    }
                    return returnValueForSave;
                };
            }
        }
        return handler;
    }
}

