/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.jpa.aop;

import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.domain.Persistable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.util.ClassUtils;

public class JpaRepositoryPointcut
extends StaticMethodMatcherPointcut {
    private static final Logger LOG = LoggerFactory.getLogger(JpaRepositoryPointcut.class);
    private static final ClassFilter CLASS_FILTER = clazz -> JpaRepository.class.isAssignableFrom(ClassUtils.getUserClass((Class)clazz));

    public ClassFilter getClassFilter() {
        return CLASS_FILTER;
    }

    public boolean matches(Method method, Class<?> targetClass) {
        Class entityClass = TypeDescriptor.valueOf(targetClass).upcast(JpaRepository.class).getResolvableType().getGeneric(new int[]{0}).resolve();
        if (!Persistable.class.isAssignableFrom(entityClass)) {
            LOG.warn("JPA repository {} detected without Persistable type parameter - entity interception is not possible.", targetClass);
            return false;
        }
        return JpaRepositoryPointcut.isEntityMethod(method);
    }

    static boolean isEntityMethod(Method method) {
        switch (method.getName()) {
            case "save": 
            case "saveAll": 
            case "saveAndFlush": 
            case "delete": 
            case "deleteInBatch": {
                return method.getParameterTypes().length == 1;
            }
            case "deleteAll": {
                return method.getParameterTypes().length <= 1;
            }
            case "deleteAllInBatch": {
                return method.getParameterTypes().length == 0;
            }
        }
        return false;
    }
}

