/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.jpa.config;

import com.foreach.across.core.AcrossModule;
import com.foreach.across.core.DynamicAcrossModule;
import com.foreach.across.core.annotations.Exposed;
import com.foreach.across.core.annotations.Module;
import com.foreach.across.core.context.info.AcrossModuleInfo;
import com.foreach.across.core.events.AcrossContextBootstrappedEvent;
import com.foreach.across.core.events.AcrossModuleBeforeBootstrapEvent;
import com.foreach.across.modules.hibernate.config.HibernatePackageBuilder;
import com.foreach.across.modules.hibernate.config.InterceptorRegistryConfiguration;
import com.foreach.across.modules.hibernate.jpa.AcrossHibernateJpaModule;
import com.foreach.across.modules.hibernate.jpa.AcrossHibernateJpaModuleSettings;
import com.foreach.across.modules.hibernate.jpa.config.JpaModuleSettingsRegistrar;
import com.foreach.across.modules.hibernate.jpa.repositories.config.ApplicationModuleRepositoryAutoConfiguration;
import com.foreach.across.modules.hibernate.jpa.services.JpaHibernateSessionHolderImpl;
import com.foreach.across.modules.hibernate.jpa.unitofwork.JpaUnitOfWorkFactoryImpl;
import com.foreach.across.modules.hibernate.modules.config.EnableTransactionManagementConfiguration;
import com.foreach.across.modules.hibernate.modules.config.ModuleBasicRepositoryInterceptorConfiguration;
import com.foreach.across.modules.hibernate.provider.HibernatePackage;
import com.foreach.across.modules.hibernate.services.HibernateSessionHolder;
import com.foreach.across.modules.hibernate.strategy.AbstractTableAliasNamingStrategy;
import com.foreach.across.modules.hibernate.unitofwork.UnitOfWorkFactory;
import com.foreach.across.modules.hibernate.util.DozerConfiguration;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.dao.PersistenceExceptionTranslationAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateSettings;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.InterfaceMaker;
import org.springframework.cglib.proxy.NoOp;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.event.EventListener;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.config.BootstrapMode;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.util.StopWatch;

@Configuration
@Import(value={JpaModuleSettingsRegistrar.class, InterceptorRegistryConfiguration.class, HibernatePackageBuilder.class, PersistenceExceptionTranslationAutoConfiguration.class, DozerConfiguration.class})
public class HibernateJpaConfiguration {
    public static final String TRANSACTION_MANAGER = "jpaTransactionManager";
    public static final String TRANSACTION_TEMPLATE = "jpaTransactionTemplate";
    public static final BootstrapMode DEFAULT_ACROSS_BOOTSTRAP_MODE = BootstrapMode.DEFAULT;
    private static final Logger LOG = LoggerFactory.getLogger(HibernateJpaConfiguration.class);
    private final AcrossHibernateJpaModule module;
    private final AcrossHibernateJpaModuleSettings settings;
    private final HibernatePackage hibernatePackage;
    private final ListableBeanFactory beanFactory;

    @Autowired
    public HibernateJpaConfiguration(@Module(value="across.currentModule") AcrossHibernateJpaModule module, @Module(value="across.currentModule") AcrossHibernateJpaModuleSettings settings, HibernatePackage hibernatePackage, ListableBeanFactory beanFactory) {
        this.module = module;
        this.settings = settings;
        this.hibernatePackage = hibernatePackage;
        this.beanFactory = beanFactory;
    }

    @Bean(name={"entityManagerFactory"})
    @Exposed
    public LocalContainerEntityManagerFactoryBean entityManagerFactory() {
        HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
        DataSource dataSource = this.retrieveDataSource();
        vendorAdapter.setShowSql(this.settings.isShowSql());
        if (this.settings.getDatabase() != null) {
            vendorAdapter.setDatabasePlatform(this.settings.getDatabasePlatform());
            vendorAdapter.setDatabase(this.settings.getDatabase());
        }
        if (this.settings.getDatabasePlatform() != null) {
            vendorAdapter.setDatabasePlatform(this.settings.getDatabasePlatform());
        }
        vendorAdapter.setDatabasePlatform(this.settings.getDatabasePlatform());
        vendorAdapter.setGenerateDdl(this.settings.isGenerateDdl());
        LocalContainerEntityManagerFactoryBean factory = new LocalContainerEntityManagerFactoryBean();
        factory.setJpaVendorAdapter((JpaVendorAdapter)vendorAdapter);
        factory.setDataSource(dataSource);
        factory.setPersistenceUnitName(this.settings.getPersistenceUnitName());
        String[] mappingResources = this.hibernatePackage.getMappingResources();
        if (mappingResources.length > 0) {
            factory.setMappingResources(this.hibernatePackage.getMappingResources());
        }
        factory.setPackagesToScan(this.hibernatePackage.getPackagesToScan());
        factory.getJpaPropertyMap().putAll(this.settings.getHibernateProperties(new HibernateSettings()));
        Map<String, String> tableAliases = this.hibernatePackage.getTableAliases();
        if (!tableAliases.isEmpty()) {
            factory.getJpaPropertyMap().put("hibernate.physical_naming_strategy", this.createTableAliasNamingStrategyClass(tableAliases).getName());
        }
        return factory;
    }

    private DataSource retrieveDataSource() {
        DataSource moduleDataSource = this.module.getDataSource();
        if (moduleDataSource != null) {
            LOG.info("Using datasource attached directly to module {} for the EntityManagerFactory", (Object)this.module.getName());
            return moduleDataSource;
        }
        if (!StringUtils.isEmpty((CharSequence)this.settings.getDataSource())) {
            LOG.info("Resolving datasource bean {} for the EntityManagerFactory", (Object)this.settings.getDataSource());
            return (DataSource)this.beanFactory.getBean(this.settings.getDataSource(), DataSource.class);
        }
        if (BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, DataSource.class).size() == 1) {
            LOG.info("Using the single datasource bean for the EntityManagerFactory");
            return (DataSource)this.beanFactory.getBean(DataSource.class);
        }
        throw new IllegalStateException("Was unable to resolve the correct datasource bean to use, bean name: " + this.settings.getDataSource());
    }

    private Class createTableAliasNamingStrategyClass(Map<String, String> tableAliases) {
        InterfaceMaker interfaceMaker = new InterfaceMaker();
        Class dynamicInterface = interfaceMaker.create();
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(AbstractTableAliasNamingStrategy.class);
        enhancer.setInterfaces(new Class[]{dynamicInterface});
        enhancer.setUseFactory(false);
        enhancer.setCallbackType(NoOp.class);
        Class strategyClass = enhancer.createClass();
        AbstractTableAliasNamingStrategy.registerTableAliases(strategyClass, tableAliases);
        return strategyClass;
    }

    @Bean
    @Exposed
    public HibernateSessionHolder hibernateSessionHolder() {
        return new JpaHibernateSessionHolderImpl();
    }

    @Bean
    @Exposed
    @ConditionalOnExpression(value="@moduleSettings.createUnitOfWorkFactory")
    public UnitOfWorkFactory unitOfWork(EntityManagerFactory entityManagerFactory) {
        return new JpaUnitOfWorkFactoryImpl(Collections.singleton(entityManagerFactory));
    }

    @EventListener
    public void registerClientModuleRepositoryInterceptors(AcrossModuleBeforeBootstrapEvent beforeBootstrapEvent) {
        if (this.settings.isRegisterRepositoryInterceptor()) {
            LOG.trace("Enabling BasicRepository EntityInterceptor support in module {}", (Object)beforeBootstrapEvent.getModule().getName());
            beforeBootstrapEvent.getBootstrapConfig().addApplicationContextConfigurer(true, new Class[]{ModuleBasicRepositoryInterceptorConfiguration.class});
        }
        if (this.settings.getApplicationModule().isRepositoryScan() && beforeBootstrapEvent.getModule().getModule() instanceof DynamicAcrossModule.DynamicApplicationModule) {
            beforeBootstrapEvent.getBootstrapConfig().addApplicationContextConfigurer(true, new Class[]{ApplicationModuleRepositoryAutoConfiguration.class});
        }
        LOG.trace("Enabling @Transaction support in module {}", (Object)beforeBootstrapEvent.getModule().getName());
        beforeBootstrapEvent.getBootstrapConfig().addApplicationContextConfigurer(true, new Class[]{EnableTransactionManagementConfiguration.class, PersistenceExceptionTranslationAutoConfiguration.class});
    }

    @Configuration
    @ConditionalOnProperty(value={"spring.data.jpa.repositories.bootstrap-mode"}, havingValue="deferred")
    public static class DeferredRepositoryInitializer {
        private static final Logger LOG = LoggerFactory.getLogger(DeferredRepositoryInitializer.class);
        @Module(value="across.currentModule")
        private final AcrossHibernateJpaModule module;
        private final ListableBeanFactory beanFactory;

        @EventListener
        public void initializeRepositories(AcrossContextBootstrappedEvent contextBootstrappedEvent) {
            Optional<AcrossModule> first = contextBootstrappedEvent.getContext().getModules().stream().filter(m -> AcrossHibernateJpaModule.class.isAssignableFrom(m.getModule().getClass())).map(AcrossModuleInfo::getModule).findFirst();
            if (first.isPresent() && first.get() == this.module) {
                LOG.info("Triggering deferred initialization of Spring Data repositories from HibernateJpaConfiguration\u2026");
                StopWatch watch = new StopWatch();
                watch.start();
                this.beanFactory.getBeansOfType(Repository.class);
                watch.stop();
                LOG.info("Spring Data repositories initialized in {}ms!", (Object)watch.getLastTaskTimeMillis());
            }
        }

        public DeferredRepositoryInitializer(AcrossHibernateJpaModule module, ListableBeanFactory beanFactory) {
            this.module = module;
            this.beanFactory = beanFactory;
        }
    }
}

