/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.jpa.config;

import com.foreach.across.core.context.ExposedBeanDefinition;
import com.foreach.across.core.transformers.ExposedBeanDefinitionTransformer;
import com.foreach.across.modules.hibernate.jpa.AcrossHibernateJpaModule;
import com.foreach.across.modules.hibernate.jpa.AcrossHibernateJpaModuleSettings;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class PrimaryTransactionManagerTransformer
implements ExposedBeanDefinitionTransformer {
    private static final Logger LOG = LoggerFactory.getLogger(PrimaryTransactionManagerTransformer.class);
    private final AcrossHibernateJpaModule module;

    public void transformBeanDefinitions(Map<String, ExposedBeanDefinition> beanDefinitions) {
        AcrossHibernateJpaModuleSettings settings = (AcrossHibernateJpaModuleSettings)((Object)this.module.getAcrossApplicationContextHolder().getApplicationContext().getBean(AcrossHibernateJpaModuleSettings.class));
        if (this.isPrimary(settings)) {
            LOG.debug("Registering PlatformTransactionManager, TransactionTemplate and HibernateSessionHolder as primary");
            beanDefinitions.get("jpaTransactionManager").setPrimary(true);
            beanDefinitions.get("jpaTransactionTemplate").setPrimary(true);
            beanDefinitions.get("hibernateSessionHolder").setPrimary(true);
            beanDefinitions.get("entityManagerFactory").setPrimary(true);
            if (beanDefinitions.containsKey("unitOfWork")) {
                beanDefinitions.get("unitOfWork").setPrimary(true);
            }
            ApplicationContext parentContext = this.module.getAcrossApplicationContextHolder().getApplicationContext().getParent();
            this.alias(parentContext, beanDefinitions, "jpaTransactionManager", "transactionManager");
            this.alias(parentContext, beanDefinitions, "jpaTransactionTemplate", "transactionTemplate");
        }
    }

    private boolean isPrimary(AcrossHibernateJpaModuleSettings settings) {
        Boolean manuallySetPrimaryStatus = settings.getPrimary();
        return manuallySetPrimaryStatus != null ? manuallySetPrimaryStatus.booleanValue() : "AcrossHibernateJpaModule".equals(this.module.getName());
    }

    private void alias(ApplicationContext parentContext, Map<String, ExposedBeanDefinition> beanDefinitions, String originalBean, String aliasToAdd) {
        if (parentContext.containsBean(aliasToAdd)) {
            LOG.debug("Unable to create '{}' alias for the '{}' - there is already a bean with that name", (Object)aliasToAdd, (Object)originalBean);
        } else {
            beanDefinitions.get(originalBean).addAlias(aliasToAdd);
        }
    }

    public PrimaryTransactionManagerTransformer(AcrossHibernateJpaModule module) {
        this.module = module;
    }
}

