/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.jpa.repositories;

import com.foreach.across.core.context.registry.AcrossContextBeanRegistry;
import com.foreach.across.modules.hibernate.jpa.aop.JpaRepositoryInterceptor;
import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Persistable;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;

public class EntityInterceptingJpaRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends JpaRepositoryFactoryBean<T, S, ID> {
    private String transactionManagerName = "transactionManager";
    private AcrossContextBeanRegistry acrossContextBeanRegistry;

    public EntityInterceptingJpaRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    @Autowired
    public void setAcrossContextBeanRegistry(AcrossContextBeanRegistry acrossContextBeanRegistry) {
        this.acrossContextBeanRegistry = acrossContextBeanRegistry;
    }

    public void setTransactionManager(String transactionManager) {
        this.transactionManagerName = transactionManager == null ? "transactionManager" : transactionManager;
        super.setTransactionManager(transactionManager);
    }

    protected RepositoryFactorySupport createRepositoryFactory(EntityManager entityManager) {
        RepositoryFactorySupport repositoryFactory = super.createRepositoryFactory(entityManager);
        repositoryFactory.addRepositoryProxyPostProcessor((RepositoryProxyPostProcessor)new EntityInterceptorProxyPostProcessor(this.acrossContextBeanRegistry, this.transactionManagerName));
        return repositoryFactory;
    }

    public static class EntityInterceptorProxyPostProcessor
    implements RepositoryProxyPostProcessor {
        public static final Logger LOG = LoggerFactory.getLogger(EntityInterceptorProxyPostProcessor.class);
        private final AcrossContextBeanRegistry contextBeanRegistry;
        private final String transactionManagerName;

        public EntityInterceptorProxyPostProcessor(AcrossContextBeanRegistry beanRegistry, String transactionManagerName) {
            this.contextBeanRegistry = beanRegistry;
            this.transactionManagerName = transactionManagerName;
        }

        public void postProcess(ProxyFactory factory, RepositoryInformation repositoryInformation) {
            List interceptors = this.contextBeanRegistry.getBeansOfType(JpaRepositoryInterceptor.class, false);
            if (!interceptors.isEmpty()) {
                if (interceptors.size() > 1) {
                    LOG.warn("More than one JpaRepositoryInterceptor bean was found: {} in total.", (Object)interceptors.size());
                }
                if (!Persistable.class.isAssignableFrom(repositoryInformation.getDomainType())) {
                    LOG.warn("JPA repository {} detected without Persistable type parameter - entity interception is not possible.", (Object)repositoryInformation.getRepositoryInterface());
                }
                JpaRepositoryInterceptor jpaRepositoryInterceptor = (JpaRepositoryInterceptor)interceptors.get(0);
                jpaRepositoryInterceptor.setTransactionManagerName(this.transactionManagerName);
                factory.addAdvice((Advice)jpaRepositoryInterceptor);
            } else {
                LOG.info("No JpaRepositoryInterceptor found - repository intercepting was possibly disabled.");
            }
        }
    }
}

