/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.jpa.repositories.config;

import com.foreach.across.modules.hibernate.jpa.config.HibernateJpaConfiguration;
import com.foreach.across.modules.hibernate.jpa.repositories.config.AcrossJpaRepositoryConfigExtension;
import com.foreach.across.modules.hibernate.jpa.repositories.config.EnableAcrossJpaRepositories;
import java.lang.annotation.Annotation;
import java.util.Locale;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.repository.config.AcrossRepositoryConfigurationDelegate;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.BootstrapMode;
import org.springframework.data.repository.config.RepositoryBeanDefinitionRegistrarSupport;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationUtils;
import org.springframework.util.StringUtils;

class AcrossJpaRepositoriesRegistrar
extends RepositoryBeanDefinitionRegistrarSupport {
    private BootstrapMode bootstrapMode = null;
    private ResourceLoader resourceLoader = null;
    private Environment environment = null;

    AcrossJpaRepositoriesRegistrar() {
    }

    protected Class<? extends Annotation> getAnnotation() {
        return EnableAcrossJpaRepositories.class;
    }

    protected RepositoryConfigurationExtension getExtension() {
        return new AcrossJpaRepositoryConfigExtension();
    }

    protected BootstrapMode getBootstrapMode() {
        return this.bootstrapMode == null ? HibernateJpaConfiguration.DEFAULT_ACROSS_BOOTSTRAP_MODE : this.bootstrapMode;
    }

    public void setEnvironment(Environment environment) {
        super.setEnvironment(environment);
        this.environment = environment;
        this.configureBootstrapMode(environment);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        super.setResourceLoader(resourceLoader);
        this.resourceLoader = resourceLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry, BeanNameGenerator generator) {
        AnnotationRepositoryConfigurationSource configurationSource = new AnnotationRepositoryConfigurationSource(metadata, this.getAnnotation(), this.resourceLoader, this.environment, registry, generator){

            public BootstrapMode getBootstrapMode() {
                return AcrossJpaRepositoriesRegistrar.this.getBootstrapMode();
            }
        };
        RepositoryConfigurationExtension extension = this.getExtension();
        RepositoryConfigurationUtils.exposeRegistration((RepositoryConfigurationExtension)extension, (BeanDefinitionRegistry)registry, (RepositoryConfigurationSource)configurationSource);
        AcrossRepositoryConfigurationDelegate delegate = new AcrossRepositoryConfigurationDelegate((RepositoryConfigurationSource)configurationSource, this.resourceLoader, this.environment);
        delegate.registerRepositoriesIn(registry, this.getExtension());
    }

    private void configureBootstrapMode(Environment environment) {
        String property = environment.getProperty("spring.data.jpa.repositories.bootstrap-mode");
        if (StringUtils.hasText((String)property)) {
            this.bootstrapMode = BootstrapMode.valueOf((String)property.toUpperCase(Locale.ENGLISH));
        }
    }
}

