/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.jpa.repositories.config;

import com.foreach.across.modules.hibernate.jpa.config.HibernateJpaConfiguration;
import com.foreach.across.modules.hibernate.jpa.repositories.config.AcrossJpaRepositoryConfigExtension;
import com.foreach.across.modules.hibernate.jpa.repositories.config.EnableAcrossJpaRepositories;
import java.lang.annotation.Annotation;
import java.util.Locale;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.boot.autoconfigure.data.AbstractRepositoryConfigurationSourceSupport;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.repository.config.AcrossRepositoryConfigurationDelegate;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.BootstrapMode;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.util.Streamable;
import org.springframework.util.StringUtils;

@Import(value={ApplicationModuleRepositoriesRegistrar.class})
public class ApplicationModuleRepositoryAutoConfiguration {

    static class ApplicationModuleRepositoriesRegistrar
    extends AbstractRepositoryConfigurationSourceSupport {
        private BootstrapMode bootstrapMode = null;
        private ResourceLoader resourceLoader = null;
        private Environment environment = null;

        ApplicationModuleRepositoriesRegistrar() {
        }

        protected Class<? extends Annotation> getAnnotation() {
            return EnableAcrossJpaRepositories.class;
        }

        protected Class<?> getConfiguration() {
            return EnableJpaRepositoriesConfiguration.class;
        }

        protected RepositoryConfigurationExtension getRepositoryConfigurationExtension() {
            return new AcrossJpaRepositoryConfigExtension();
        }

        protected BootstrapMode getBootstrapMode() {
            return this.bootstrapMode == null ? HibernateJpaConfiguration.DEFAULT_ACROSS_BOOTSTRAP_MODE : this.bootstrapMode;
        }

        public void setEnvironment(Environment environment) {
            super.setEnvironment(environment);
            this.configureBootstrapMode(environment);
            this.environment = environment;
        }

        public void setResourceLoader(ResourceLoader resourceLoader) {
            super.setResourceLoader(resourceLoader);
            this.resourceLoader = resourceLoader;
        }

        public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry, BeanNameGenerator generator) {
            AnnotationMetadata meta = AnnotationMetadata.introspect(this.getConfiguration());
            AutoConfiguredAnnotationRepositoryConfigurationSource configurationSource = new AutoConfiguredAnnotationRepositoryConfigurationSource(meta, (Class)this.getAnnotation(), this.resourceLoader, this.environment, registry, generator){};
            AcrossRepositoryConfigurationDelegate delegate = new AcrossRepositoryConfigurationDelegate((RepositoryConfigurationSource)configurationSource, this.resourceLoader, this.environment);
            delegate.registerRepositoriesIn(registry, this.getRepositoryConfigurationExtension());
        }

        private void configureBootstrapMode(Environment environment) {
            String property = environment.getProperty("spring.data.jpa.repositories.bootstrap-mode");
            if (StringUtils.hasText((String)property)) {
                this.bootstrapMode = BootstrapMode.valueOf((String)property.toUpperCase(Locale.ENGLISH));
            }
        }

        @EnableAcrossJpaRepositories
        private static class EnableJpaRepositoriesConfiguration {
            private EnableJpaRepositoriesConfiguration() {
            }
        }

        private class AutoConfiguredAnnotationRepositoryConfigurationSource
        extends AnnotationRepositoryConfigurationSource {
            AutoConfiguredAnnotationRepositoryConfigurationSource(AnnotationMetadata metadata, Class<? extends Annotation> annotation, ResourceLoader resourceLoader, Environment environment, BeanDefinitionRegistry registry, BeanNameGenerator generator) {
                super(metadata, annotation, resourceLoader, environment, registry, generator);
            }

            public Streamable<String> getBasePackages() {
                return ApplicationModuleRepositoriesRegistrar.this.getBasePackages();
            }

            public BootstrapMode getBootstrapMode() {
                return ApplicationModuleRepositoriesRegistrar.this.getBootstrapMode();
            }
        }
    }
}

