/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.jpa.unitofwork;

import com.foreach.across.modules.hibernate.unitofwork.CallableUnitOfWork;
import com.foreach.across.modules.hibernate.unitofwork.RunnableUnitOfWork;
import com.foreach.across.modules.hibernate.unitofwork.UnitOfWork;
import com.foreach.across.modules.hibernate.unitofwork.UnitOfWorkFactory;
import java.util.Collection;
import java.util.concurrent.Callable;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import lombok.NonNull;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class JpaUnitOfWorkFactoryImpl
implements UnitOfWorkFactory {
    private final Collection<EntityManagerFactory> entityManagerFactories;

    public JpaUnitOfWorkFactoryImpl(@NonNull Collection<EntityManagerFactory> entityManagerFactories) {
        if (entityManagerFactories == null) {
            throw new NullPointerException("entityManagerFactories is marked non-null but is null");
        }
        this.entityManagerFactories = entityManagerFactories;
    }

    @Override
    public Runnable create(Runnable runnable) {
        return new RunnableUnitOfWork(this, runnable);
    }

    @Override
    public <T> Callable<T> create(Callable<T> callable) {
        return new CallableUnitOfWork<T>(this, callable);
    }

    @Override
    public void restart() {
        this.stop();
        this.start();
    }

    @Override
    public UnitOfWork start() {
        for (EntityManagerFactory emf : this.entityManagerFactories) {
            try {
                if (!TransactionSynchronizationManager.hasResource((Object)emf)) {
                    LOG.trace("Opening entity manager for {}", (Object)emf);
                    EntityManager entityManager = emf.createEntityManager();
                    TransactionSynchronizationManager.bindResource((Object)emf, (Object)new EntityManagerHolder(entityManager));
                    continue;
                }
                LOG.trace("Not opening entity manager for {} as factory is already bound", (Object)emf);
            }
            catch (Exception e) {
                LOG.error("Exception starting unit of work for {}", (Object)emf, (Object)e);
            }
        }
        return new UnitOfWork(this);
    }

    @Override
    public void stop() {
        for (EntityManagerFactory emf : this.entityManagerFactories) {
            try {
                EntityManagerHolder holder = (EntityManagerHolder)TransactionSynchronizationManager.getResource((Object)emf);
                if (holder == null) continue;
                if (!TransactionSynchronizationManager.isActualTransactionActive()) {
                    LOG.trace("Closing entity manager for {}", (Object)emf);
                    EntityManagerFactoryUtils.closeEntityManager((EntityManager)holder.getEntityManager());
                } else {
                    LOG.trace("Not closing entity manager for {} as transaction is active", (Object)emf);
                }
                TransactionSynchronizationManager.unbindResource((Object)emf);
            }
            catch (Exception e) {
                LOG.error("Exception stopping unit of work for {}", (Object)emf, (Object)e);
            }
        }
    }
}

