/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.provider;

import com.foreach.across.modules.hibernate.provider.HibernatePackageProvider;
import com.foreach.across.modules.hibernate.provider.HibernatePackageRegistry;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class HibernatePackage
implements HibernatePackageRegistry {
    private final String name;
    private Collection<String> packagesToScan = new HashSet<String>();
    private Collection<String> mappingResources = new HashSet<String>();
    private Map<String, String> tableAliases = new HashMap<String, String>();

    public HibernatePackage(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String[] getPackagesToScan() {
        return this.packagesToScan.toArray(new String[this.packagesToScan.size()]);
    }

    public String[] getMappingResources() {
        return this.mappingResources.toArray(new String[this.mappingResources.size()]);
    }

    public Map<String, String> getTableAliases() {
        return this.tableAliases;
    }

    @Override
    public void addPackageToScan(String ... packageToScan) {
        this.packagesToScan.addAll(Arrays.asList(packageToScan));
    }

    @Override
    public void addPackageToScan(Class ... classes) {
        for (Class c : classes) {
            this.addPackageToScan(c.getPackage().getName());
        }
    }

    @Override
    public void addMappingResource(String ... mappingResource) {
        this.mappingResources.addAll(Arrays.asList(mappingResource));
    }

    @Override
    public void add(HibernatePackageProvider provider) {
        this.packagesToScan.addAll(Arrays.asList(provider.getPackagesToScan()));
        this.mappingResources.addAll(Arrays.asList(provider.getMappingResources()));
        this.tableAliases.putAll(provider.getTableAliases());
    }
}

