/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.provider;

import com.foreach.across.modules.hibernate.provider.HibernatePackageProvider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class HibernatePackageProviderComposite
implements HibernatePackageProvider {
    private HibernatePackageProvider[] providers;

    public HibernatePackageProviderComposite(HibernatePackageProvider ... providers) {
        this.providers = providers;
    }

    @Override
    public String[] getPackagesToScan() {
        HashSet<String> packagesToScan = new HashSet<String>();
        for (HibernatePackageProvider provider : this.providers) {
            packagesToScan.addAll(Arrays.asList(provider.getPackagesToScan()));
        }
        return packagesToScan.toArray(new String[packagesToScan.size()]);
    }

    @Override
    public String[] getMappingResources() {
        HashSet<String> mappingResources = new HashSet<String>();
        for (HibernatePackageProvider provider : this.providers) {
            mappingResources.addAll(Arrays.asList(provider.getMappingResources()));
        }
        return mappingResources.toArray(new String[mappingResources.size()]);
    }

    @Override
    public Map<String, String> getTableAliases() {
        HashMap<String, String> tableAliases = new HashMap<String, String>();
        for (HibernatePackageProvider provider : this.providers) {
            tableAliases.putAll(provider.getTableAliases());
        }
        return tableAliases;
    }
}

