/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.repositories;

import com.foreach.across.core.revision.Revision;
import com.foreach.across.core.revision.RevisionBasedEntity;
import com.foreach.across.core.revision.RevisionBasedEntityManager;
import com.foreach.across.modules.hibernate.repositories.Undeletable;
import com.foreach.across.modules.hibernate.services.HibernateSessionHolder;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collection;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;

public abstract class BasicRevisionBasedJpaRepository<T extends RevisionBasedEntity<T>, U, R extends Revision<U>>
extends RevisionBasedEntityManager<T, U, R> {
    private final Class<T> clazz;
    private HibernateSessionHolder hibernateSessionHolder;

    @Autowired
    public BasicRevisionBasedJpaRepository() {
        ParameterizedType genericSuperclass = (ParameterizedType)((Object)((Object)this)).getClass().getGenericSuperclass();
        this.clazz = (Class)genericSuperclass.getActualTypeArguments()[0];
    }

    protected void insert(T entity) {
        this.session().save(entity);
    }

    protected void update(T entity, int currentFirstRevision, int currentLastRevision) {
        this.session().update(entity);
    }

    protected void delete(T entity) {
        if (entity instanceof Undeletable) {
            ((Undeletable)entity).setDeleted(true);
            this.session().saveOrUpdate(entity);
        } else {
            this.session().delete(entity);
        }
    }

    protected void deleteAllForOwner(U owner) {
        Collection<T> items = this.list(this.distinct(this.addOwnerRestriction(owner)));
        for (RevisionBasedEntity item : items) {
            this.delete(item);
        }
    }

    protected Collection<T> getAllForLatestRevision(U owner) {
        return this.list(this.distinct(this.addOwnerRestriction(owner), this.revisionSelector(0)));
    }

    protected Collection<T> getAllForSpecificRevision(U owner, int revisionNumber) {
        return this.list(this.distinct(this.addOwnerRestriction(owner), this.revisionSelector(revisionNumber)));
    }

    protected Collection<T> getAllForDraftRevision(U owner) {
        return this.list(this.distinct(this.addOwnerRestriction(owner), this.revisionSelector(-1)));
    }

    protected Collection<T> list(CriteriaQuery<T> criteriaQuery) {
        return this.session().createQuery(criteriaQuery).list();
    }

    protected abstract Specification<T> addOwnerRestriction(U var1);

    protected CriteriaQuery<T> distinct(Specification<T> ... specifications) {
        CriteriaBuilder cb = this.session().getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(this.clazz);
        Root from = query.from(this.clazz);
        Predicate[] predicates = (Predicate[])Arrays.stream(specifications).map(s -> s.toPredicate(from, query, cb)).toArray(Predicate[]::new);
        return query.distinct(true).where(predicates);
    }

    protected Specification<T> revisionSelector(int revisionNumber) {
        switch (revisionNumber) {
            case -1: {
                return (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[]{cb.or((Expression)cb.equal((Expression)root.get("firstRevision"), (Object)-1), (Expression)cb.equal((Expression)root.get("removalRevision"), (Object)0))});
            }
            case 0: {
                return (Specification & Serializable)(root, query, cb) -> cb.and((Expression)cb.ge((Expression)root.get("firstRevision"), (Number)0), (Expression)cb.equal((Expression)root.get("removalRevision"), (Object)0));
            }
        }
        return (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[]{cb.ge((Expression)root.get("firstRevision"), (Number)0), cb.le((Expression)root.get("firstRevision"), (Number)revisionNumber), cb.or((Expression)cb.equal((Expression)root.get("removalRevision"), (Object)0), (Expression)cb.gt((Expression)root.get("removalRevision"), (Number)revisionNumber))});
    }

    protected Session session() {
        return this.hibernateSessionHolder.getCurrentSession();
    }

    @Autowired
    public void setHibernateSessionHolder(HibernateSessionHolder hibernateSessionHolder) {
        this.hibernateSessionHolder = hibernateSessionHolder;
    }
}

