/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.types;

import com.foreach.across.modules.hibernate.types.BitFlag;
import com.foreach.across.modules.hibernate.types.HibernateIdLookup;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.IntegerType;
import org.hibernate.usertype.UserType;

public abstract class HibernateBitFlag<T extends BitFlag>
extends HibernateIdLookup<T, Integer>
implements UserType {
    private final IntegerType TYPE = IntegerType.INSTANCE;

    public HibernateBitFlag(Class<T> clazz) {
        super(clazz);
    }

    @Override
    public Object nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException {
        Integer identifier = (Integer)this.TYPE.get(rs, names[0], session);
        if (rs.wasNull()) {
            return EnumSet.noneOf(super.returnedClass());
        }
        return this.fromInteger(identifier, super.returnedClass());
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        try {
            int result = this.toInteger((Set)value);
            this.TYPE.set(st, (Object)result, index, session);
        }
        catch (Exception e) {
            throw new HibernateException("Exception while getting ids from set", (Throwable)e);
        }
    }

    private <E extends Enum<E>> EnumSet<E> fromInteger(Integer identifier, Class<E> enumType) {
        Enum[] enumValues;
        EnumSet<Enum> result = EnumSet.noneOf(enumType);
        for (Enum enumValue : enumValues = (Enum[])enumType.getEnumConstants()) {
            if ((((BitFlag)((Object)enumValue)).getId() & identifier) <= 0) continue;
            result.add(enumValue);
        }
        return result;
    }

    private <E extends Enum<E>> int toInteger(Set<E> enumSet) {
        int result = 0;
        if (enumSet != null) {
            for (Enum enumValue : enumSet) {
                result |= ((BitFlag)((Object)enumValue)).getId().intValue();
            }
        }
        return result;
    }
}

