/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.types;

import com.foreach.across.modules.hibernate.types.IdLookup;
import com.foreach.across.modules.hibernate.util.HibernateTypeLookup;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.usertype.UserType;

public abstract class HibernateIdLookup<T extends IdLookup<K>, K>
implements UserType {
    private final AbstractSingleColumnStandardBasicType<K> type;
    private final Class<T> clazz;

    public HibernateIdLookup(Class<T> clazz) {
        this.type = HibernateTypeLookup.getForIdLookupType(clazz);
        this.clazz = clazz;
    }

    public int[] sqlTypes() {
        return new int[]{this.type.sqlType()};
    }

    public Class returnedClass() {
        return this.clazz;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y;
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException {
        IdLookup[] enumValues;
        Object identifier = this.type.get(rs, names[0], session);
        if (identifier == null) {
            return null;
        }
        for (IdLookup enumValue : enumValues = (IdLookup[])this.clazz.getEnumConstants()) {
            if (!enumValue.getId().equals(identifier)) continue;
            return enumValue;
        }
        throw new HibernateException("Could not find enum for value: " + identifier + " in clazz " + this.clazz);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        try {
            if (value != null) {
                this.type.set(st, ((IdLookup)value).getId(), index, session);
            } else {
                st.setNull(index, this.type.sqlType());
            }
        }
        catch (Exception e) {
            throw new HibernateException("Exception while getting ids from set", (Throwable)e);
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }
}

