/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.unitofwork;

import com.foreach.across.modules.hibernate.unitofwork.CallableUnitOfWork;
import com.foreach.across.modules.hibernate.unitofwork.RunnableUnitOfWork;
import com.foreach.across.modules.hibernate.unitofwork.UnitOfWork;
import com.foreach.across.modules.hibernate.unitofwork.UnitOfWorkFactory;
import java.util.Collection;
import java.util.concurrent.Callable;

public class CompositeUnitOfWorkFactory
implements UnitOfWorkFactory {
    private final Collection<UnitOfWorkFactory> members;

    public CompositeUnitOfWorkFactory(Collection<UnitOfWorkFactory> members) {
        this.members = members;
    }

    @Override
    public Runnable create(Runnable runnable) {
        return new RunnableUnitOfWork(this, runnable);
    }

    @Override
    public <T> Callable<T> create(Callable<T> callable) {
        return new CallableUnitOfWork<T>(this, callable);
    }

    @Override
    public void restart() {
        this.stop();
        this.start();
    }

    @Override
    public UnitOfWork start() {
        for (UnitOfWorkFactory unitOfWorkFactory : this.members) {
            if (unitOfWorkFactory == this) continue;
            unitOfWorkFactory.start();
        }
        return new UnitOfWork(this);
    }

    @Override
    public void stop() {
        for (UnitOfWorkFactory unitOfWorkFactory : this.members) {
            if (unitOfWorkFactory == this) continue;
            unitOfWorkFactory.stop();
        }
    }
}

