/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.unitofwork;

import com.foreach.across.modules.hibernate.unitofwork.CallableUnitOfWork;
import com.foreach.across.modules.hibernate.unitofwork.RunnableUnitOfWork;
import com.foreach.across.modules.hibernate.unitofwork.UnitOfWork;
import com.foreach.across.modules.hibernate.unitofwork.UnitOfWorkFactory;
import java.util.Collection;
import java.util.concurrent.Callable;
import lombok.NonNull;
import org.hibernate.CacheMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate5.SessionFactoryUtils;
import org.springframework.orm.hibernate5.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class UnitOfWorkFactoryImpl
implements UnitOfWorkFactory {
    private final Collection<SessionFactory> sessionFactories;

    public UnitOfWorkFactoryImpl(@NonNull Collection<SessionFactory> sessionFactories) {
        if (sessionFactories == null) {
            throw new NullPointerException("sessionFactories is marked non-null but is null");
        }
        this.sessionFactories = sessionFactories;
    }

    @Override
    public Runnable create(Runnable runnable) {
        return new RunnableUnitOfWork(this, runnable);
    }

    @Override
    public <T> Callable<T> create(Callable<T> callable) {
        return new CallableUnitOfWork<T>(this, callable);
    }

    @Override
    public UnitOfWork start() {
        this.start(false);
        return new UnitOfWork(this);
    }

    @Override
    public void restart() {
        this.stop();
        this.start();
    }

    private void start(boolean ignoreCache) {
        for (SessionFactory sessionFactory : this.sessionFactories) {
            try {
                if (!TransactionSynchronizationManager.hasResource((Object)sessionFactory)) {
                    LOG.trace("Opening session for {}", (Object)sessionFactory);
                    Session session = sessionFactory.openSession();
                    if (ignoreCache) {
                        session.setCacheMode(CacheMode.IGNORE);
                    }
                    TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)new SessionHolder(session));
                    continue;
                }
                LOG.trace("Not opening session for {} as sessionFactory is already bound", (Object)sessionFactory);
            }
            catch (Exception e) {
                LOG.error("Exception starting unit of work for {}", (Object)sessionFactory, (Object)e);
            }
        }
    }

    @Override
    public void stop() {
        for (SessionFactory sessionFactory : this.sessionFactories) {
            try {
                SessionHolder holder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)sessionFactory);
                if (holder == null) continue;
                if (!TransactionSynchronizationManager.isActualTransactionActive()) {
                    LOG.trace("Closing session for {}", (Object)sessionFactory);
                    Session session = holder.getSession();
                    session.flush();
                    SessionFactoryUtils.closeSession((Session)session);
                } else {
                    LOG.trace("Not closing session for {} as transaction is active", (Object)sessionFactory);
                }
                TransactionSynchronizationManager.unbindResource((Object)sessionFactory);
            }
            catch (Exception e) {
                LOG.error("Exception stopping unit of work for {}", (Object)sessionFactory, (Object)e);
            }
        }
    }
}

