/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.util;

import com.foreach.across.modules.hibernate.business.IdBasedEntity;
import com.foreach.across.modules.hibernate.dto.IdBasedEntityDto;
import com.foreach.across.modules.hibernate.repositories.BasicRepository;
import javax.persistence.EntityNotFoundException;
import org.springframework.beans.BeanUtils;
import org.springframework.data.repository.CrudRepository;

public class BasicServiceHelper {
    private BasicServiceHelper() {
    }

    public static <T> T save(T dto, CrudRepository<T, ?> repository) {
        Object saved = repository.save(dto);
        BeanUtils.copyProperties((Object)saved, dto);
        return (T)saved;
    }

    public static <T extends IdBasedEntity> T save(IdBasedEntityDto<T> dto, Class<T> entityClass, BasicRepository<T> repository) {
        IdBasedEntity entity;
        if (!dto.isNewEntity()) {
            entity = (IdBasedEntity)repository.getById(dto.getId());
            if (entity == null) {
                throw new EntityNotFoundException(String.format("No %s with id %s", entityClass.getSimpleName(), dto.getId()));
            }
        } else {
            try {
                entity = (IdBasedEntity)entityClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        BeanUtils.copyProperties(dto, (Object)entity);
        if (dto.isNewEntity()) {
            repository.create(entity);
        } else {
            repository.update(entity);
        }
        dto.copyFrom(entity);
        return (T)entity;
    }
}

