/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.util;

import com.github.dozermapper.core.factory.BeanCreationDirective;
import com.github.dozermapper.core.factory.BeanCreationStrategy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.springframework.util.ReflectionUtils;

public class DomainTypesBeanCreationStrategy
implements BeanCreationStrategy {
    public boolean isApplicable(BeanCreationDirective directive) {
        return Arrays.stream(directive.getActualClass().getDeclaredMethods()).anyMatch(m -> {
            boolean hasOfMethod = "of".equals(m.getName());
            boolean isStatic = Modifier.isStatic(m.getModifiers());
            return hasOfMethod && isStatic;
        });
    }

    public Object create(BeanCreationDirective directive) {
        Constructor<?> constructor = directive.getActualClass().getConstructors()[0];
        try {
            Field declaredField = directive.getSrcClass().getDeclaredFields()[0];
            ReflectionUtils.makeAccessible((Field)declaredField);
            Object o = ReflectionUtils.getField((Field)declaredField, (Object)directive.getSrcObject());
            return constructor.newInstance(o);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }
}

