/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.util;

import com.foreach.across.core.annotations.Exposed;
import com.foreach.across.modules.hibernate.AcrossHibernateModuleSettings;
import com.foreach.across.modules.hibernate.util.DozerMapperCustomizationRegistry;
import com.foreach.across.modules.hibernate.util.DtoUtils;
import com.github.dozermapper.core.DozerBeanMapper;
import com.github.dozermapper.core.DozerBeanMapperBuilder;
import com.github.dozermapper.core.Mapper;
import java.util.Collections;
import java.util.Optional;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={DozerBeanMapper.class})
public class DozerConfiguration {
    private final AcrossHibernateModuleSettings acrossHibernateModuleSettings;

    @Bean
    @Exposed
    public DozerMapperCustomizationRegistry registry() {
        if (!this.acrossHibernateModuleSettings.isAdvancedDtoConversion()) {
            return null;
        }
        return new DozerMapperCustomizationRegistry();
    }

    @Bean
    @Exposed
    public Mapper dozerBeanMapper(ConfigurableBeanFactory beanFactory, Optional<DozerMapperCustomizationRegistry> oRegistry) {
        if (!this.acrossHibernateModuleSettings.isAdvancedDtoConversion() || !oRegistry.isPresent()) {
            return null;
        }
        DozerMapperCustomizationRegistry registry = oRegistry.get();
        ClassLoader classLoader = beanFactory.getBeanClassLoader();
        Mapper build = DozerBeanMapperBuilder.create().withCustomFieldMapper(registry.getCustomFieldMapper()).withBeanMappingsBuilders((beanContainer, destBeanCreator, propertyDescriptorFactory) -> {
            destBeanCreator.addPluggedStrategy(registry.getBeanCreationStrategy());
            return Collections.emptyList();
        }).withClassLoader(classLoader).build();
        DtoUtils.dtoMapper = (entityType, entity) -> build.map(entity, entityType);
        return build;
    }

    public DozerConfiguration(AcrossHibernateModuleSettings acrossHibernateModuleSettings) {
        this.acrossHibernateModuleSettings = acrossHibernateModuleSettings;
    }
}

