/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.util;

import com.github.dozermapper.core.CustomFieldMapper;
import com.github.dozermapper.core.DozerBeanMapper;
import com.github.dozermapper.core.factory.BeanCreationDirective;
import com.github.dozermapper.core.factory.BeanCreationStrategy;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.util.Assert;

@ConditionalOnClass(value={DozerBeanMapper.class})
public class DozerMapperCustomizationRegistry {
    public static final int DEFAULT_ORDER = 1000;
    private final List<DozerCustomizationRegistrar<BeanCreationStrategy>> strategies = new ArrayList<DozerCustomizationRegistrar<BeanCreationStrategy>>();
    private final List<DozerCustomizationRegistrar<CustomFieldMapper>> fieldMappers = new ArrayList<DozerCustomizationRegistrar<CustomFieldMapper>>();

    CustomFieldMapper getCustomFieldMapper() {
        return (source, destination, sourceFieldValue, classMap, fieldMapping) -> {
            List<DozerCustomizationRegistrar<CustomFieldMapper>> list = this.fieldMappers;
            synchronized (list) {
                return this.fieldMappers.stream().map(DozerCustomizationRegistrar::customization).anyMatch(cfm -> cfm.mapField(source, destination, sourceFieldValue, classMap, fieldMapping));
            }
        };
    }

    BeanCreationStrategy getBeanCreationStrategy() {
        final Function<BeanCreationDirective, Optional> strategyResolver = directive -> {
            List<DozerCustomizationRegistrar<BeanCreationStrategy>> list = this.strategies;
            synchronized (list) {
                return this.strategies.stream().map(DozerCustomizationRegistrar::customization).filter(bcs -> bcs.isApplicable(directive)).findFirst();
            }
        };
        return new BeanCreationStrategy(){
            ThreadLocal<BeanCreationStrategy> strategyHolder = new ThreadLocal();

            public boolean isApplicable(BeanCreationDirective directive) {
                Optional strategy = (Optional)strategyResolver.apply(directive);
                if (strategy.isPresent()) {
                    this.strategyHolder.set((BeanCreationStrategy)strategy.get());
                    return true;
                }
                return false;
            }

            public Object create(BeanCreationDirective directive) {
                BeanCreationStrategy beanCreationStrategy = this.strategyHolder.get();
                Object result = beanCreationStrategy.create(directive);
                this.strategyHolder.remove();
                return result;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(@NonNull DozerCustomizationRegistrar customizationRegistrar) {
        if (customizationRegistrar == null) {
            throw new NullPointerException("customizationRegistrar is marked non-null but is null");
        }
        Assert.notNull((Object)customizationRegistrar, (String)"Registrar should not be null!");
        Assert.notNull((Object)customizationRegistrar.name(), (String)"Registrar requires a name to be filled in!");
        Object customization = customizationRegistrar.customization();
        Assert.notNull(customization, (String)"Registrar requires a customization to be set!");
        if (CustomFieldMapper.class.isAssignableFrom(customization.getClass())) {
            List<DozerCustomizationRegistrar<CustomFieldMapper>> list = this.fieldMappers;
            synchronized (list) {
                this.handle(this.fieldMappers, customizationRegistrar);
            }
        }
        if (BeanCreationStrategy.class.isAssignableFrom(customization.getClass())) {
            List<DozerCustomizationRegistrar<BeanCreationStrategy>> list = this.strategies;
            synchronized (list) {
                this.handle(this.strategies, customizationRegistrar);
            }
        }
    }

    private <T> void handle(List<DozerCustomizationRegistrar<T>> collection, DozerCustomizationRegistrar<T> toRegister) {
        collection.stream().filter(s -> StringUtils.equals((CharSequence)toRegister.name(), (CharSequence)s.name())).findFirst().ifPresent(collection::remove);
        collection.add(toRegister);
        collection.sort(Comparator.comparing(DozerCustomizationRegistrar::order));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBeanCreationStrategy(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        List<DozerCustomizationRegistrar<BeanCreationStrategy>> list = this.strategies;
        synchronized (list) {
            this.strategies.removeIf(s -> StringUtils.equals((CharSequence)name, (CharSequence)s.name()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCustomFieldMapper(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        List<DozerCustomizationRegistrar<CustomFieldMapper>> list = this.fieldMappers;
        synchronized (list) {
            this.fieldMappers.removeIf(s -> StringUtils.equals((CharSequence)name, (CharSequence)s.name()));
        }
    }

    public static DozerCustomizationRegistrar<BeanCreationStrategy> beanCreationStrategyRegistrar() {
        return new DozerCustomizationRegistrar<BeanCreationStrategy>();
    }

    public static DozerCustomizationRegistrar<CustomFieldMapper> customFieldMapperRegistrar() {
        return new DozerCustomizationRegistrar<CustomFieldMapper>();
    }

    public static class DozerCustomizationRegistrar<T> {
        private String name;
        private T customization;
        private int order = 1000;

        protected String name() {
            return this.name;
        }

        protected T customization() {
            return this.customization;
        }

        protected int order() {
            return this.order;
        }

        public DozerCustomizationRegistrar<T> name(String name) {
            this.name = name;
            return this;
        }

        public DozerCustomizationRegistrar<T> customization(T customization) {
            this.customization = customization;
            return this;
        }

        public DozerCustomizationRegistrar<T> order(int order) {
            this.order = order;
            return this;
        }

        public DozerCustomizationRegistrar(String name, T customization, int order) {
            this.name = name;
            this.customization = customization;
            this.order = order;
        }

        public DozerCustomizationRegistrar() {
        }
    }
}

