/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.util;

import com.foreach.across.modules.hibernate.util.DtoMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ClassUtils;

public class DtoUtils {
    static DtoMapper dtoMapper = DtoUtils::createDto;

    private DtoUtils() {
    }

    public static <T> T createDto(T entity) {
        if (entity != null) {
            Class entityType = ClassUtils.getUserClass(entity);
            return dtoMapper.createDto(entityType, entity);
        }
        return null;
    }

    static <T> T createDto(Class<T> entityType, T entity) {
        try {
            T dto = entityType.newInstance();
            BeanUtils.copyProperties(entity, dto);
            return dto;
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }
}

