/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.util;

import com.foreach.across.modules.hibernate.services.HibernateSessionHolder;
import com.github.dozermapper.core.CustomFieldMapper;
import com.github.dozermapper.core.Mapper;
import com.github.dozermapper.core.MappingException;
import com.github.dozermapper.core.classmap.ClassMap;
import com.github.dozermapper.core.fieldmap.FieldMap;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;

public class HibernateProxyDozerFieldMapper
implements CustomFieldMapper {
    private static final Logger LOG = LoggerFactory.getLogger(HibernateProxyDozerFieldMapper.class);
    private final Mapper mapper;
    private final HibernateSessionHolder hibernateSessionHolder;

    public boolean mapField(Object source, Object destination, Object sourceFieldValue, ClassMap classMap, FieldMap fieldMapping) {
        if (!Hibernate.isInitialized((Object)sourceFieldValue)) {
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(destination.getClass());
            ValueHolder valueHolder = new ValueHolder(this.mapper, this.hibernateSessionHolder, destination.getClass());
            valueHolder.setObject(sourceFieldValue);
            enhancer.setCallback((Callback)((MethodInterceptor)(obj, method, args, proxy) -> {
                valueHolder.initializeHibernateObject();
                valueHolder.convertToDto();
                return method.invoke(valueHolder.getObject(), args);
            }));
            fieldMapping.writeDestValue(destination, enhancer.create());
            return true;
        }
        return false;
    }

    public HibernateProxyDozerFieldMapper(Mapper mapper, HibernateSessionHolder hibernateSessionHolder) {
        this.mapper = mapper;
        this.hibernateSessionHolder = hibernateSessionHolder;
    }

    static class ValueHolder {
        private final Mapper mapper;
        private final HibernateSessionHolder hibernateSessionHolder;
        private final Class destinationType;
        private Object object;
        private boolean hibernateInitialized = false;
        private boolean mappingAttempted = false;

        void initializeHibernateObject() {
            if (!this.mappingAttempted && !this.hibernateInitialized) {
                try (Session session = this.hibernateSessionHolder.openSession();){
                    session.update(this.object);
                    Hibernate.initialize((Object)this.object);
                    this.hibernateInitialized = true;
                }
            }
        }

        void convertToDto() {
            if (!this.mappingAttempted) {
                try {
                    this.mappingAttempted = true;
                    this.object = this.mapper.map(this.object, this.destinationType);
                }
                catch (MappingException e) {
                    LOG.error("Unexpected exception whilst creating a dto of the initialized hibernate object", (Throwable)e);
                }
            }
        }

        public ValueHolder(Mapper mapper, HibernateSessionHolder hibernateSessionHolder, Class destinationType) {
            this.mapper = mapper;
            this.hibernateSessionHolder = hibernateSessionHolder;
            this.destinationType = destinationType;
        }

        public Mapper getMapper() {
            return this.mapper;
        }

        public HibernateSessionHolder getHibernateSessionHolder() {
            return this.hibernateSessionHolder;
        }

        public Class getDestinationType() {
            return this.destinationType;
        }

        public Object getObject() {
            return this.object;
        }

        public boolean isHibernateInitialized() {
            return this.hibernateInitialized;
        }

        public boolean isMappingAttempted() {
            return this.mappingAttempted;
        }

        public void setObject(Object object) {
            this.object = object;
        }

        public void setHibernateInitialized(boolean hibernateInitialized) {
            this.hibernateInitialized = hibernateInitialized;
        }

        public void setMappingAttempted(boolean mappingAttempted) {
            this.mappingAttempted = mappingAttempted;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ValueHolder)) {
                return false;
            }
            ValueHolder other = (ValueHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isHibernateInitialized() != other.isHibernateInitialized()) {
                return false;
            }
            if (this.isMappingAttempted() != other.isMappingAttempted()) {
                return false;
            }
            Mapper this$mapper = this.getMapper();
            Mapper other$mapper = other.getMapper();
            if (this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper)) {
                return false;
            }
            HibernateSessionHolder this$hibernateSessionHolder = this.getHibernateSessionHolder();
            HibernateSessionHolder other$hibernateSessionHolder = other.getHibernateSessionHolder();
            if (this$hibernateSessionHolder == null ? other$hibernateSessionHolder != null : !this$hibernateSessionHolder.equals(other$hibernateSessionHolder)) {
                return false;
            }
            Class this$destinationType = this.getDestinationType();
            Class other$destinationType = other.getDestinationType();
            if (this$destinationType == null ? other$destinationType != null : !this$destinationType.equals(other$destinationType)) {
                return false;
            }
            Object this$object = this.getObject();
            Object other$object = other.getObject();
            return !(this$object == null ? other$object != null : !this$object.equals(other$object));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ValueHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isHibernateInitialized() ? 79 : 97);
            result = result * 59 + (this.isMappingAttempted() ? 79 : 97);
            Mapper $mapper = this.getMapper();
            result = result * 59 + ($mapper == null ? 43 : $mapper.hashCode());
            HibernateSessionHolder $hibernateSessionHolder = this.getHibernateSessionHolder();
            result = result * 59 + ($hibernateSessionHolder == null ? 43 : $hibernateSessionHolder.hashCode());
            Class $destinationType = this.getDestinationType();
            result = result * 59 + ($destinationType == null ? 43 : $destinationType.hashCode());
            Object $object = this.getObject();
            result = result * 59 + ($object == null ? 43 : $object.hashCode());
            return result;
        }

        public String toString() {
            return "HibernateProxyDozerFieldMapper.ValueHolder(mapper=" + this.getMapper() + ", hibernateSessionHolder=" + this.getHibernateSessionHolder() + ", destinationType=" + this.getDestinationType() + ", object=" + this.getObject() + ", hibernateInitialized=" + this.isHibernateInitialized() + ", mappingAttempted=" + this.isMappingAttempted() + ")";
        }
    }
}

